/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class SharedExecutorService {
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryImpl());

    private SharedExecutorService() {
    }

    public static final ExecutorService get() {
        return executor;
    }

    private static final class ThreadFactoryImpl
    implements ThreadFactory {
        private static final AtomicInteger counter = new AtomicInteger(0);
        private final ThreadGroup _threadGroup;

        public ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this._threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this._threadGroup, r, "MetaModel.SharedExecutorService.Thread." + counter.incrementAndGet());
            thread.setDaemon(true);
            thread.setPriority(5);
            return thread;
        }
    }
}

