/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eobjects.metamodel.AbstractDataContext;
import org.eobjects.metamodel.CompositeQueryDelegate;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.CompositeSchema;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.Func;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataContext
extends AbstractDataContext {
    private static final Logger logger = LoggerFactory.getLogger(CompositeDataContext.class);
    private Map<String, CompositeSchema> _compositeSchemas = new HashMap<String, CompositeSchema>();
    private DataContext[] _delegates;

    public CompositeDataContext(DataContext ... delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("delegates cannot be null");
        }
        this._delegates = delegates;
    }

    public CompositeDataContext(Collection<DataContext> delegates) {
        if (delegates == null) {
            throw new IllegalArgumentException("delegates cannot be null");
        }
        this._delegates = delegates.toArray(new DataContext[delegates.size()]);
    }

    @Override
    public DataSet executeQuery(Query query) throws MetaModelException {
        HashSet<DataContext> dataContexts = new HashSet<DataContext>();
        List items = query.getFromClause().getItems();
        for (FromItem item : items) {
            List<FromItem> tableFromItems = MetaModelHelper.getTableFromItems(item);
            for (FromItem fromItem : tableFromItems) {
                Table table = fromItem.getTable();
                DataContext dc = this.getDataContext(table);
                if (dc == null) {
                    throw new MetaModelException("Could not resolve child-datacontext for table: " + table);
                }
                dataContexts.add(dc);
            }
        }
        if (dataContexts.isEmpty()) {
            throw new MetaModelException("No suiting delegate DataContext to execute query: " + query);
        }
        if (dataContexts.size() == 1) {
            Iterator it = dataContexts.iterator();
            assert (it.hasNext());
            DataContext dc = (DataContext)it.next();
            return dc.executeQuery(query);
        }
        Func<Table, DataContext> dataContextRetrievalFunction = new Func<Table, DataContext>(){

            @Override
            public DataContext eval(Table table) {
                return CompositeDataContext.this.getDataContext(table);
            }
        };
        return new CompositeQueryDelegate(dataContextRetrievalFunction).executeQuery(query);
    }

    private DataContext getDataContext(Table table) {
        Schema schema;
        DataContext result = null;
        if (table != null && (schema = table.getSchema()) != null) {
            Schema dcSchema;
            for (DataContext dc : this._delegates) {
                dcSchema = dc.getSchemaByName(schema.getName());
                if (dcSchema == null || dcSchema != schema) continue;
                logger.debug("DataContext for '{}' resolved (using identity) to: '{}'", (Object)table, (Object)dcSchema);
                result = dc;
                break;
            }
            if (result == null) {
                for (DataContext dc : this._delegates) {
                    dcSchema = dc.getSchemaByName(schema.getName());
                    if (dcSchema == null || !dcSchema.equals(schema)) continue;
                    logger.debug("DataContext for '{}' resolved (using equals) to: '{}'", (Object)table, (Object)dcSchema);
                    result = dc;
                    break;
                }
            }
        }
        if (result == null) {
            logger.warn("Couldn't resolve DataContext for {}", (Object)table);
        }
        return result;
    }

    @Override
    public String getDefaultSchemaName() throws MetaModelException {
        for (DataContext dc : this._delegates) {
            Schema schema = dc.getDefaultSchema();
            if (schema == null) continue;
            return schema.getName();
        }
        return null;
    }

    @Override
    public Schema getSchemaByNameInternal(String name) throws MetaModelException {
        CompositeSchema compositeSchema = this._compositeSchemas.get(name);
        if (compositeSchema != null) {
            return compositeSchema;
        }
        ArrayList<Schema> matchingSchemas = new ArrayList<Schema>();
        for (DataContext dc : this._delegates) {
            Schema schema = dc.getSchemaByName(name);
            if (schema == null) continue;
            matchingSchemas.add(schema);
        }
        if (matchingSchemas.size() == 1) {
            return (Schema)matchingSchemas.iterator().next();
        }
        if (matchingSchemas.size() > 1) {
            if (logger.isInfoEnabled()) {
                logger.info("Name-clash detected for Schema '{}'. Creating CompositeSchema.");
            }
            compositeSchema = new CompositeSchema(name, matchingSchemas);
            this._compositeSchemas.put(name, compositeSchema);
            return compositeSchema;
        }
        return null;
    }

    @Override
    public String[] getSchemaNamesInternal() throws MetaModelException {
        HashSet<String> set = new HashSet<String>();
        for (DataContext dc : this._delegates) {
            String[] schemaNames;
            for (String name : schemaNames = dc.getSchemaNames()) {
                if (MetaModelHelper.isInformationSchema(name)) continue;
                set.add(name);
            }
        }
        Object[] result = set.toArray(new String[set.size()]);
        Arrays.sort(result);
        return result;
    }
}

