/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.CachingDataSetHeader;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.EmptyDataSet;
import org.eobjects.metamodel.data.FilteredDataSet;
import org.eobjects.metamodel.data.IRowFilter;
import org.eobjects.metamodel.data.InMemoryDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.data.SubSelectionDataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.GroupByItem;
import org.eobjects.metamodel.query.OrderByItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.parser.QueryParser;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.SuperColumnType;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.AggregateBuilder;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.ObjectComparator;
import org.eobjects.metamodel.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaModelHelper {
    private static final Logger logger = LoggerFactory.getLogger(MetaModelHelper.class);

    private MetaModelHelper() {
    }

    public static Table[] getTables(Collection<Table> tableList, Iterable<Column> columnList) {
        HashSet<Table> set = new HashSet<Table>();
        set.addAll(tableList);
        for (Column column : columnList) {
            set.add(column.getTable());
        }
        return set.toArray(new Table[set.size()]);
    }

    public static boolean isInformationSchema(Schema schema) {
        String name = schema.getName();
        return MetaModelHelper.isInformationSchema(name);
    }

    public static boolean isInformationSchema(String name) {
        if (name == null) {
            return false;
        }
        return "information_schema".equals(name.toLowerCase());
    }

    public static Table[] getTables(Iterable<Column> columns) {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Column column : columns) {
            Table table = column.getTable();
            if (result.contains(table)) continue;
            result.add(table);
        }
        return result.toArray(new Table[result.size()]);
    }

    public static Column[] getTableColumns(Table table, Iterable<Column> columns) {
        if (table == null) {
            return new Column[0];
        }
        ArrayList<Column> result = new ArrayList<Column>();
        for (Column column : columns) {
            boolean sameTable = table.equals(column.getTable());
            if (!sameTable) continue;
            result.add(column);
        }
        return result.toArray(new Column[result.size()]);
    }

    public static Column[] getTableColumns(Table table, Column[] columns) {
        return MetaModelHelper.getTableColumns(table, Arrays.asList(columns));
    }

    public static DataSet getCarthesianProduct(DataSet ... fromDataSets) {
        return MetaModelHelper.getCarthesianProduct(fromDataSets, new FilterItem[0]);
    }

    public static DataSet getCarthesianProduct(DataSet[] fromDataSets, Iterable<FilterItem> whereItems) {
        if (fromDataSets.length == 1) {
            return MetaModelHelper.getFiltered(fromDataSets[0], whereItems);
        }
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (DataSet dataSet : fromDataSets) {
            for (int i = 0; i < dataSet.getSelectItems().length; ++i) {
                SelectItem selectItem = dataSet.getSelectItems()[i];
                selectItems.add(selectItem);
            }
        }
        int selectItemOffset = 0;
        ArrayList<Object> data = new ArrayList<Object>();
        for (int fromDataSetIndex = 0; fromDataSetIndex < fromDataSets.length; ++fromDataSetIndex) {
            DataSet fromDataSet = fromDataSets[fromDataSetIndex];
            SelectItem[] fromSelectItems = fromDataSet.getSelectItems();
            if (fromDataSetIndex == 0) {
                while (fromDataSet.next()) {
                    Object[] objectArray = fromDataSet.getRow().getValues();
                    Object[] row = new Object[selectItems.size()];
                    System.arraycopy(objectArray, 0, row, selectItemOffset, objectArray.length);
                    data.add(row);
                }
                fromDataSet.close();
            } else {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                while (fromDataSet.next()) {
                    arrayList.add(fromDataSet.getRow().getValues());
                }
                fromDataSet.close();
                for (int i = 0; i < data.size(); i += arrayList.size()) {
                    Object[] originalRow = (Object[])data.get(i);
                    data.remove(i);
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Object[] newRow = (Object[])arrayList.get(j);
                        System.arraycopy(newRow, 0, originalRow, selectItemOffset, newRow.length);
                        data.add(i + j, originalRow.clone());
                    }
                }
            }
            selectItemOffset += fromSelectItems.length;
        }
        if (data.isEmpty()) {
            return new EmptyDataSet(selectItems);
        }
        CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
        ArrayList<Row> rows = new ArrayList<Row>(data.size());
        for (Object[] objectArray : data) {
            rows.add(new DefaultRow(header, objectArray, null));
        }
        DataSet result = new InMemoryDataSet((DataSetHeader)header, rows);
        if (whereItems != null) {
            result = MetaModelHelper.getFiltered(result, whereItems);
        }
        return result;
    }

    public static DataSet getCarthesianProduct(DataSet[] fromDataSets, FilterItem ... filterItems) {
        return MetaModelHelper.getCarthesianProduct(fromDataSets, Arrays.asList(filterItems));
    }

    public static DataSet getFiltered(DataSet dataSet, Iterable<FilterItem> filterItems) {
        List<IRowFilter> filters = CollectionUtils.map(filterItems, new Func<FilterItem, IRowFilter>(){

            @Override
            public IRowFilter eval(FilterItem filterItem) {
                return filterItem;
            }
        });
        if (filters.isEmpty()) {
            return dataSet;
        }
        return new FilteredDataSet(dataSet, filters.toArray(new IRowFilter[filters.size()]));
    }

    public static DataSet getFiltered(DataSet dataSet, FilterItem ... filterItems) {
        return MetaModelHelper.getFiltered(dataSet, Arrays.asList(filterItems));
    }

    public static DataSet getSelection(List<SelectItem> selectItems, DataSet dataSet) {
        SelectItem[] dataSetSelectItems = dataSet.getSelectItems();
        if (selectItems.size() == dataSetSelectItems.length) {
            boolean same = true;
            int i = 0;
            for (SelectItem selectItem : selectItems) {
                if (!EqualsBuilder.equals(selectItem, dataSetSelectItems[i])) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (same) {
                return dataSet;
            }
        }
        SelectItem[] selectItemsArray = selectItems.toArray(new SelectItem[selectItems.size()]);
        return new SubSelectionDataSet(selectItemsArray, dataSet);
    }

    public static DataSet getSelection(SelectItem[] selectItems, DataSet dataSet) {
        return MetaModelHelper.getSelection(Arrays.asList(selectItems), dataSet);
    }

    public static DataSet getGrouped(List<SelectItem> selectItems, DataSet dataSet, Collection<GroupByItem> groupByItems) {
        return MetaModelHelper.getGrouped(selectItems, dataSet, groupByItems.toArray(new GroupByItem[groupByItems.size()]));
    }

    public static DataSet getGrouped(List<SelectItem> selectItems, DataSet dataSet, GroupByItem[] groupByItems) {
        DataSet result = dataSet;
        if (groupByItems != null && groupByItems.length > 0) {
            HashMap uniqueRows = new HashMap();
            SelectItem[] groupBySelects = new SelectItem[groupByItems.length];
            for (int i = 0; i < groupBySelects.length; ++i) {
                groupBySelects[i] = groupByItems[i].getSelectItem();
            }
            CachingDataSetHeader groupByHeader = new CachingDataSetHeader(groupBySelects);
            List<SelectItem> functionItems = MetaModelHelper.getFunctionSelectItems(selectItems);
            while (dataSet.next()) {
                Map functionInput;
                Row row = dataSet.getRow();
                Row uniqueRow = row.getSubSelection(groupByHeader);
                if (!uniqueRows.containsKey(uniqueRow)) {
                    functionInput = new HashMap();
                    for (SelectItem item : functionItems) {
                        functionInput.put(item, new ArrayList());
                    }
                    uniqueRows.put(uniqueRow, functionInput);
                } else {
                    functionInput = (Map)uniqueRows.get(uniqueRow);
                }
                for (SelectItem item : functionItems) {
                    List objects = (List)functionInput.get(item);
                    Column column = item.getColumn();
                    if (column != null) {
                        Object value = row.getValue(new SelectItem(column));
                        objects.add(value);
                        continue;
                    }
                    if (SelectItem.isCountAllItem(item)) {
                        objects.add("");
                        continue;
                    }
                    throw new IllegalArgumentException("Expression function not supported: " + item);
                }
            }
            dataSet.close();
            ArrayList<Row> resultData = new ArrayList<Row>();
            CachingDataSetHeader resultHeader = new CachingDataSetHeader(selectItems);
            for (Map.Entry entry : uniqueRows.entrySet()) {
                Row row = (Row)entry.getKey();
                Map functionInput = (Map)entry.getValue();
                Object[] resultRow = new Object[selectItems.size()];
                int i = 0;
                for (SelectItem item : selectItems) {
                    int uniqueRowIndex = row.indexOf(item);
                    if (uniqueRowIndex != -1) {
                        resultRow[i] = row.getValue(uniqueRowIndex);
                    } else {
                        List objects = (List)functionInput.get(item);
                        if (objects != null) {
                            Object functionResult;
                            resultRow[i] = functionResult = item.getFunction().evaluate(objects.toArray());
                        } else if (item.getFunction() != null) {
                            logger.error("No function input found for SelectItem: {}", (Object)item);
                        }
                    }
                    ++i;
                }
                resultData.add(new DefaultRow(resultHeader, resultRow, null));
            }
            result = resultData.isEmpty() ? new EmptyDataSet(selectItems) : new InMemoryDataSet((DataSetHeader)resultHeader, resultData);
        }
        result = MetaModelHelper.getSelection(selectItems, result);
        return result;
    }

    public static DataSet getAggregated(List<SelectItem> workSelectItems, DataSet dataSet) {
        AggregateBuilder aggregateBuilder;
        SimpleDataSetHeader header;
        boolean onlyAggregates;
        List<SelectItem> functionItems = MetaModelHelper.getFunctionSelectItems(workSelectItems);
        if (functionItems.isEmpty()) {
            return dataSet;
        }
        HashMap aggregateBuilders = new HashMap();
        for (SelectItem item : functionItems) {
            aggregateBuilders.put(item, item.getFunction().build());
        }
        if (functionItems.size() != workSelectItems.size()) {
            onlyAggregates = false;
            header = new CachingDataSetHeader(workSelectItems);
        } else {
            onlyAggregates = true;
            header = new SimpleDataSetHeader(workSelectItems);
        }
        ArrayList<Row> resultRows = new ArrayList<Row>();
        while (dataSet.next()) {
            Row inputRow = dataSet.getRow();
            for (SelectItem item : functionItems) {
                aggregateBuilder = (AggregateBuilder)aggregateBuilders.get(item);
                Column column = item.getColumn();
                if (column != null) {
                    Object value = inputRow.getValue(new SelectItem(column));
                    aggregateBuilder.add(value);
                    continue;
                }
                if (SelectItem.isCountAllItem(item)) {
                    aggregateBuilder.add("");
                    continue;
                }
                throw new IllegalArgumentException("Expression function not supported: " + item);
            }
            if (onlyAggregates) continue;
            Object[] values = new Object[header.size()];
            for (int i = 0; i < header.size(); ++i) {
                Object value = inputRow.getValue(header.getSelectItem(i));
                if (value == null) continue;
                values[i] = value;
            }
            resultRows.add(new DefaultRow(header, values));
        }
        dataSet.close();
        HashMap functionResult = new HashMap();
        for (SelectItem item : functionItems) {
            aggregateBuilder = (AggregateBuilder)aggregateBuilders.get(item);
            Object result = aggregateBuilder.getAggregate();
            functionResult.put(item, result);
        }
        boolean noResultRows = resultRows.isEmpty();
        if (onlyAggregates || noResultRows) {
            Object[] values = new Object[header.size()];
            for (int i = 0; i < header.size(); ++i) {
                values[i] = functionResult.get(header.getSelectItem(i));
            }
            DefaultRow row = new DefaultRow(header, values);
            resultRows.add(row);
        } else {
            for (int i = 0; i < resultRows.size(); ++i) {
                Row row = (Row)resultRows.get(i);
                Object[] values = row.getValues();
                for (Map.Entry entry : functionResult.entrySet()) {
                    SelectItem item = (SelectItem)entry.getKey();
                    int itemIndex = row.indexOf(item);
                    if (itemIndex == -1) continue;
                    Object value = entry.getValue();
                    values[itemIndex] = value;
                }
                resultRows.set(i, new DefaultRow(header, values));
            }
        }
        return new InMemoryDataSet((DataSetHeader)header, resultRows);
    }

    public static List<SelectItem> getFunctionSelectItems(Iterable<SelectItem> selectItems) {
        return CollectionUtils.filter(selectItems, new Predicate<SelectItem>(){

            @Override
            public Boolean eval(SelectItem arg) {
                return arg.getFunction() != null;
            }
        });
    }

    public static DataSet getOrdered(DataSet dataSet, List<OrderByItem> orderByItems) {
        return MetaModelHelper.getOrdered(dataSet, orderByItems.toArray(new OrderByItem[orderByItems.size()]));
    }

    public static DataSet getOrdered(DataSet dataSet, final OrderByItem ... orderByItems) {
        if (orderByItems != null && orderByItems.length != 0) {
            final int[] sortIndexes = new int[orderByItems.length];
            for (int i = 0; i < orderByItems.length; ++i) {
                int indexOf;
                OrderByItem item = orderByItems[i];
                sortIndexes[i] = indexOf = dataSet.indexOf(item.getSelectItem());
            }
            List<Row> data = MetaModelHelper.readDataSetFull(dataSet);
            if (data.isEmpty()) {
                return new EmptyDataSet(dataSet.getSelectItems());
            }
            final Comparator<Object> valueComparator = ObjectComparator.getComparator();
            Comparator<Row> comparator = new Comparator<Row>(){

                @Override
                public int compare(Row o1, Row o2) {
                    for (int i = 0; i < sortIndexes.length; ++i) {
                        Object sortObj2;
                        int sortIndex = sortIndexes[i];
                        Object sortObj1 = o1.getValue(sortIndex);
                        int compare = valueComparator.compare(sortObj1, sortObj2 = o2.getValue(sortIndex));
                        if (compare == 0) continue;
                        OrderByItem orderByItem = orderByItems[i];
                        boolean ascending = orderByItem.isAscending();
                        if (ascending) {
                            return compare;
                        }
                        return compare * -1;
                    }
                    return 0;
                }
            };
            Collections.sort(data, comparator);
            dataSet = new InMemoryDataSet(data);
        }
        return dataSet;
    }

    public static List<Row> readDataSetFull(DataSet dataSet) {
        List<Row> result;
        if (dataSet instanceof InMemoryDataSet) {
            result = ((InMemoryDataSet)dataSet).getRows();
        } else {
            result = new ArrayList<Row>();
            while (dataSet.next()) {
                result.add(dataSet.getRow());
            }
        }
        dataSet.close();
        return result;
    }

    public static FromItem[] getTableFromItems(Query q) {
        ArrayList<FromItem> result = new ArrayList<FromItem>();
        List items = q.getFromClause().getItems();
        for (FromItem item : items) {
            result.addAll(MetaModelHelper.getTableFromItems(item));
        }
        return result.toArray(new FromItem[result.size()]);
    }

    public static List<FromItem> getTableFromItems(FromItem item) {
        ArrayList<FromItem> result = new ArrayList<FromItem>();
        if (item.getTable() != null) {
            result.add(item);
        } else if (item.getSubQuery() != null) {
            FromItem[] sqItems = MetaModelHelper.getTableFromItems(item.getSubQuery());
            for (int i = 0; i < sqItems.length; ++i) {
                result.add(sqItems[i]);
            }
        } else if (item.getJoin() != null) {
            FromItem leftSide = item.getLeftSide();
            result.addAll(MetaModelHelper.getTableFromItems(leftSide));
            FromItem rightSide = item.getRightSide();
            result.addAll(MetaModelHelper.getTableFromItems(rightSide));
        } else {
            throw new IllegalStateException("FromItem was neither of Table type, SubQuery type or Join type: " + item);
        }
        return result;
    }

    public static Row executeSingleRowQuery(DataContext dataContext, Query query) throws MetaModelException {
        DataSet dataSet = dataContext.executeQuery(query);
        boolean next = dataSet.next();
        if (!next) {
            throw new MetaModelException("No rows returned from query: " + query);
        }
        Row row = dataSet.getRow();
        next = dataSet.next();
        if (next) {
            throw new MetaModelException("More than one row returned from query: " + query);
        }
        dataSet.close();
        return row;
    }

    public static DataSet getLeftJoin(DataSet ds1, DataSet ds2, FilterItem[] onConditions) {
        if (ds1 == null) {
            throw new IllegalArgumentException("Left DataSet cannot be null");
        }
        if (ds2 == null) {
            throw new IllegalArgumentException("Right DataSet cannot be null");
        }
        SelectItem[] si1 = ds1.getSelectItems();
        SelectItem[] si2 = ds2.getSelectItems();
        SelectItem[] selectItems = new SelectItem[si1.length + si2.length];
        System.arraycopy(si1, 0, selectItems, 0, si1.length);
        System.arraycopy(si2, 0, selectItems, si1.length, si2.length);
        ArrayList<Row> resultRows = new ArrayList<Row>();
        List<Row> ds2data = MetaModelHelper.readDataSetFull(ds2);
        if (ds2data.isEmpty()) {
            return MetaModelHelper.getSelection(selectItems, ds1);
        }
        CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
        while (ds1.next()) {
            Row ds1row = ds1.getRow();
            ArrayList<Row> ds1rows = new ArrayList<Row>();
            ds1rows.add(ds1row);
            DataSet carthesianProduct = MetaModelHelper.getCarthesianProduct(new DataSet[]{new InMemoryDataSet((DataSetHeader)new CachingDataSetHeader(si1), ds1rows), new InMemoryDataSet((DataSetHeader)new CachingDataSetHeader(si2), ds2data)}, onConditions);
            List<Row> carthesianRows = MetaModelHelper.readDataSetFull(carthesianProduct);
            if (carthesianRows.size() > 0) {
                resultRows.addAll(carthesianRows);
                continue;
            }
            Object[] values = ds1row.getValues();
            Object[] row = new Object[selectItems.length];
            System.arraycopy(values, 0, row, 0, values.length);
            resultRows.add(new DefaultRow(header, row));
        }
        ds1.close();
        if (resultRows.isEmpty()) {
            return new EmptyDataSet(selectItems);
        }
        return new InMemoryDataSet((DataSetHeader)header, resultRows);
    }

    public static DataSet getRightJoin(DataSet ds1, DataSet ds2, FilterItem[] onConditions) {
        SelectItem[] ds1selects = ds1.getSelectItems();
        SelectItem[] ds2selects = ds2.getSelectItems();
        SelectItem[] leftOrderedSelects = new SelectItem[ds1selects.length + ds2selects.length];
        System.arraycopy(ds1selects, 0, leftOrderedSelects, 0, ds1selects.length);
        System.arraycopy(ds2selects, 0, leftOrderedSelects, ds1selects.length, ds2selects.length);
        DataSet dataSet = MetaModelHelper.getLeftJoin(ds2, ds1, onConditions);
        dataSet = MetaModelHelper.getSelection(leftOrderedSelects, dataSet);
        return dataSet;
    }

    public static SelectItem[] createSelectItems(Column ... columns) {
        SelectItem[] items = new SelectItem[columns.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new SelectItem(columns[i]);
        }
        return items;
    }

    public static DataSet getDistinct(DataSet dataSet) {
        SelectItem[] selectItems = dataSet.getSelectItems();
        GroupByItem[] groupByItems = new GroupByItem[selectItems.length];
        for (int i = 0; i < groupByItems.length; ++i) {
            groupByItems[i] = new GroupByItem(selectItems[i]);
        }
        return MetaModelHelper.getGrouped(Arrays.asList(selectItems), dataSet, groupByItems);
    }

    public static Table[] getTables(Column[] columns) {
        return MetaModelHelper.getTables(Arrays.asList(columns));
    }

    public static Column[] getColumnsByType(Column[] columns, final ColumnType columnType) {
        return CollectionUtils.filter(columns, new Predicate<Column>(){

            @Override
            public Boolean eval(Column column) {
                return column.getType() == columnType;
            }
        }).toArray(new Column[0]);
    }

    public static Column[] getColumnsBySuperType(Column[] columns, final SuperColumnType superColumnType) {
        return CollectionUtils.filter(columns, new Predicate<Column>(){

            @Override
            public Boolean eval(Column column) {
                return column.getType().getSuperType() == superColumnType;
            }
        }).toArray(new Column[0]);
    }

    public static Query parseQuery(DataContext dc, String queryString) {
        QueryParser parser = new QueryParser(dc, queryString);
        return parser.parse();
    }
}

