/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import org.eobjects.metamodel.convert.StringToBooleanConverter;
import org.eobjects.metamodel.convert.StringToDateConverter;
import org.eobjects.metamodel.convert.StringToDoubleConverter;
import org.eobjects.metamodel.convert.StringToIntegerConverter;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.util.BooleanComparator;
import org.eobjects.metamodel.util.TimeComparator;

final class ColumnTypeDetector {
    private boolean _booleanPossible = true;
    private boolean _integerPossible = true;
    private boolean _doublePossible = true;
    private boolean _datePossible = true;

    ColumnTypeDetector() {
    }

    public void registerValue(String stringValue) {
        if (stringValue == null || stringValue.length() == 0) {
            return;
        }
        if (this._booleanPossible) {
            try {
                BooleanComparator.parseBoolean(stringValue);
            }
            catch (IllegalArgumentException e) {
                this._booleanPossible = false;
            }
        }
        if (this._doublePossible) {
            try {
                Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                this._doublePossible = false;
                this._integerPossible = false;
            }
            if (this._integerPossible) {
                try {
                    Integer.parseInt(stringValue);
                }
                catch (NumberFormatException e) {
                    this._integerPossible = false;
                }
            }
        }
        if (this._datePossible && TimeComparator.toDate(stringValue) == null) {
            this._datePossible = false;
        }
    }

    public TypeConverter<?, ?> createConverter() {
        if (this._booleanPossible) {
            return new StringToBooleanConverter();
        }
        if (this._integerPossible) {
            return new StringToIntegerConverter();
        }
        if (this._doublePossible) {
            return new StringToDoubleConverter();
        }
        if (this._datePossible) {
            return new StringToDateConverter();
        }
        return null;
    }
}

