/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConvertedDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(ConvertedDataSet.class);
    private final DataSet _dataSet;
    private final TypeConverter<?, ?>[] _converters;

    public ConvertedDataSet(DataSet dataSet, TypeConverter<?, ?>[] converters) {
        super(dataSet.getSelectItems());
        this._dataSet = dataSet;
        this._converters = converters;
    }

    @Override
    public boolean next() {
        return this._dataSet.next();
    }

    @Override
    public Row getRow() {
        Row sourceRow = this._dataSet.getRow();
        Object[] values = new Object[this._converters.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = sourceRow.getValue(i);
            TypeConverter<?, ?> converter = this._converters[i];
            if (converter != null) {
                Object virtualValue = converter.toVirtualValue(value);
                logger.debug("Converted physical value {} to {}", value, virtualValue);
                value = virtualValue;
            }
            values[i] = value;
        }
        return new DefaultRow(this.getHeader(), values);
    }

    @Override
    public void close() {
        this._dataSet.close();
    }
}

