/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import java.util.HashMap;
import java.util.Map;
import org.eobjects.metamodel.convert.ConvertedDataSet;
import org.eobjects.metamodel.convert.HasReadTypeConverters;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.intercept.DataSetInterceptor;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

public class ConvertedDataSetInterceptor
implements DataSetInterceptor,
HasReadTypeConverters {
    private Map<Column, TypeConverter<?, ?>> _converters;

    public ConvertedDataSetInterceptor() {
        this(new HashMap());
    }

    public ConvertedDataSetInterceptor(Map<Column, TypeConverter<?, ?>> converters) {
        this._converters = converters;
    }

    @Override
    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        if (converter == null) {
            this._converters.remove(column);
        } else {
            this._converters.put(column, converter);
        }
    }

    protected Map<Column, TypeConverter<?, ?>> getConverters(DataSet dataSet) {
        return this._converters;
    }

    @Override
    public final DataSet intercept(DataSet dataSet) {
        Map<Column, TypeConverter<?, ?>> converters = this.getConverters(dataSet);
        if (converters.isEmpty()) {
            return dataSet;
        }
        boolean hasConverter = false;
        SelectItem[] selectItems = dataSet.getSelectItems();
        TypeConverter[] converterArray = new TypeConverter[selectItems.length];
        for (int i = 0; i < selectItems.length; ++i) {
            TypeConverter<?, ?> converter;
            SelectItem selectItem = selectItems[i];
            Column column = selectItem.getColumn();
            if (column == null || selectItem.getFunction() != null || (converter = converters.get(column)) == null) continue;
            hasConverter = true;
            converterArray[i] = converter;
        }
        if (!hasConverter) {
            return dataSet;
        }
        return new ConvertedDataSet(dataSet, converterArray);
    }
}

