/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.convert;

import java.util.HashMap;
import java.util.Map;
import org.eobjects.metamodel.convert.Converters;
import org.eobjects.metamodel.convert.TypeConverter;
import org.eobjects.metamodel.intercept.RowUpdationInterceptor;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertedRowUpdationInterceptor
implements RowUpdationInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ConvertedRowUpdationInterceptor.class);
    private final Map<Column, TypeConverter<?, ?>> _converters;

    public ConvertedRowUpdationInterceptor() {
        this(new HashMap());
    }

    public ConvertedRowUpdationInterceptor(Map<Column, TypeConverter<?, ?>> converters) {
        this._converters = converters;
    }

    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        if (converter == null) {
            this._converters.remove(column);
        } else {
            this._converters.put(column, converter);
        }
    }

    @Override
    public RowUpdationBuilder intercept(RowUpdationBuilder update) {
        if (this._converters.isEmpty()) {
            return update;
        }
        logger.debug("Update statement after conversion:  {}", (Object)update);
        update = Converters.convertRow(update, this._converters);
        logger.debug("Update statement after conversion:  {}", (Object)update);
        return update;
    }
}

