/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

public abstract class AbstractRow
implements Cloneable,
Row {
    private static final long serialVersionUID = 1L;

    protected abstract DataSetHeader getHeader();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValues());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Arrays.equals(this.getValues(), other.getValues());
    }

    public final String toString() {
        return "Row[values=" + Arrays.toString(this.getValues()) + "]";
    }

    @Override
    public final Object getValue(SelectItem item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public final Style getStyle(SelectItem item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return Style.NO_STYLE;
        }
        return this.getStyle(index);
    }

    @Override
    public final Style getStyle(Column column) {
        int index = this.indexOf(column);
        if (index == -1) {
            return Style.NO_STYLE;
        }
        return this.getStyle(index);
    }

    @Override
    public Object[] getValues() {
        Object[] values = new Object[this.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getValue(i);
        }
        return values;
    }

    @Override
    public final Object getValue(Column column) {
        int index = this.indexOf(column);
        if (index == -1) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public final int indexOf(SelectItem item) {
        if (item == null) {
            return -1;
        }
        return this.getHeader().indexOf(item);
    }

    @Override
    public final int indexOf(Column column) {
        if (column == null) {
            return -1;
        }
        return this.getHeader().indexOf(column);
    }

    @Override
    public Row getSubSelection(SelectItem[] selectItems) {
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return this.getSubSelection(header);
    }

    @Override
    public final SelectItem[] getSelectItems() {
        return this.getHeader().getSelectItems();
    }

    @Override
    public final int size() {
        return this.getHeader().size();
    }

    @Override
    public Style[] getStyles() {
        Style[] styles = new Style[this.size()];
        for (int i = 0; i < styles.length; ++i) {
            styles[i] = this.getStyle(i);
        }
        return styles;
    }

    protected Row clone() {
        return new DefaultRow(this.getHeader(), this.getValues(), this.getStyles());
    }

    @Override
    public final Row getSubSelection(DataSetHeader header) {
        int size = header.size();
        Object[] values = new Object[size];
        Style[] styles = new Style[size];
        for (int i = 0; i < size; ++i) {
            SelectItem selectItem = header.getSelectItem(i);
            if (selectItem.getSubQuerySelectItem() != null) {
                values[i] = this.getValue(selectItem.getSubQuerySelectItem());
                styles[i] = this.getStyle(selectItem.getSubQuerySelectItem());
                if (values[i] != null) continue;
                values[i] = this.getValue(selectItem);
                styles[i] = this.getStyle(selectItem);
                continue;
            }
            values[i] = this.getValue(selectItem);
            styles[i] = this.getStyle(selectItem);
        }
        return new DefaultRow(header, values, styles);
    }
}

