/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.data.AbstractRow;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.query.SelectItem;

public final class DefaultRow
extends AbstractRow
implements Row {
    private static final long serialVersionUID = 1L;
    private final DataSetHeader _header;
    private final Object[] _values;
    private final Style[] _styles;
    @Deprecated
    private List<SelectItem> _items;

    public DefaultRow(DataSetHeader header, Object[] values, Style[] styles) {
        if (header == null) {
            throw new IllegalArgumentException("DataSet header cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (header.size() != values.length) {
            throw new IllegalArgumentException("Header size and values length must be equal. " + header.size() + " select items present in header and encountered these values: " + Arrays.toString(values));
        }
        if (styles != null) {
            if (values.length != styles.length) {
                throw new IllegalArgumentException("Values length and styles length must be equal. " + values.length + " values present and encountered these styles: " + Arrays.toString(styles));
            }
            boolean entirelyNoStyle = true;
            for (int i = 0; i < styles.length; ++i) {
                if (styles[i] == null) {
                    throw new IllegalArgumentException("Elements in the style array cannot be null");
                }
                if (!entirelyNoStyle || Style.NO_STYLE.equals(styles[i])) continue;
                entirelyNoStyle = false;
            }
            if (entirelyNoStyle) {
                styles = null;
            }
        }
        this._header = header;
        this._values = values;
        this._styles = styles;
    }

    public DefaultRow(DataSetHeader header, Object[] values) {
        this(header, values, null);
    }

    @Deprecated
    public DefaultRow(SelectItem[] items, Object[] values) {
        this(Arrays.asList(items), values, null);
    }

    @Deprecated
    public DefaultRow(SelectItem[] items, Object[] values, Style[] styles) {
        this(Arrays.asList(items), values, styles);
    }

    @Deprecated
    public DefaultRow(List<SelectItem> items, Object[] values) {
        this(items, values, null);
    }

    @Deprecated
    public DefaultRow(List<SelectItem> items, Object[] values, Style[] styles) {
        this(new SimpleDataSetHeader(items), values, styles);
    }

    @Override
    public Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        return this._values[index];
    }

    @Override
    public Object[] getValues() {
        return this._values;
    }

    @Override
    public Style getStyle(int index) throws IndexOutOfBoundsException {
        if (this._styles == null) {
            return Style.NO_STYLE;
        }
        return this._styles[index];
    }

    @Override
    public Style[] getStyles() {
        return this._styles;
    }

    @Override
    protected DataSetHeader getHeader() {
        if (this._header == null && this._items != null) {
            return new SimpleDataSetHeader(this._items);
        }
        return this._header;
    }
}

