/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.RowPublisher;
import org.eobjects.metamodel.data.RowPublisherImpl;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.SharedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowPublisherDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(RowPublisherDataSet.class);
    private final int _maxRows;
    private final Action<RowPublisher> _publishAction;
    private RowPublisherImpl _rowPublisher;
    private boolean _closed;

    public RowPublisherDataSet(SelectItem[] selectItems, int maxRows, Action<RowPublisher> publishAction) {
        super(selectItems);
        this._maxRows = maxRows;
        this._publishAction = publishAction;
        this._closed = false;
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    @Override
    public void close() {
        super.close();
        this._closed = true;
        if (this._rowPublisher != null) {
            this._rowPublisher.finished();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    @Override
    public boolean next() {
        if (this._rowPublisher == null) {
            this._rowPublisher = new RowPublisherImpl(this);
            logger.info("Starting separate thread for publishing action: {}", this._publishAction);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean successful = false;
                    try {
                        RowPublisherDataSet.this._publishAction.run(RowPublisherDataSet.this._rowPublisher);
                        logger.debug("Publshing action finished!");
                        successful = true;
                    }
                    catch (Exception e) {
                        RowPublisherDataSet.this._rowPublisher.failed(e);
                    }
                    if (successful) {
                        RowPublisherDataSet.this._rowPublisher.finished();
                    }
                }
            };
            SharedExecutorService.get().submit(runnable);
        }
        return this._rowPublisher.next();
    }

    @Override
    public Row getRow() {
        if (this._rowPublisher == null) {
            return null;
        }
        return this._rowPublisher.getRow();
    }
}

