/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.delete;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.query.FilterClause;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.AbstractFilterBuilder;
import org.eobjects.metamodel.query.builder.FilterBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public abstract class AbstractRowDeletionBuilder
implements RowDeletionBuilder {
    private final Table _table;
    private final List<FilterItem> _whereItems;

    public AbstractRowDeletionBuilder(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        this._table = table;
        this._whereItems = new ArrayList<FilterItem>();
    }

    protected List<FilterItem> getWhereItems() {
        return this._whereItems;
    }

    @Override
    public FilterBuilder<RowDeletionBuilder> where(Column column) {
        SelectItem selectItem = new SelectItem(column);
        return new AbstractFilterBuilder<RowDeletionBuilder>(selectItem){

            @Override
            protected RowDeletionBuilder applyFilter(FilterItem filter) {
                return AbstractRowDeletionBuilder.this.where(filter);
            }
        };
    }

    @Override
    public FilterBuilder<RowDeletionBuilder> where(String columnName) {
        Column column = this._table.getColumnByName(columnName);
        if (column == null) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        return this.where(column);
    }

    @Override
    public RowDeletionBuilder where(FilterItem ... filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }

    @Override
    public RowDeletionBuilder where(Iterable<FilterItem> filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    protected boolean deleteRow(Row row) {
        List<FilterItem> whereItems = this.getWhereItems();
        for (FilterItem filterItem : whereItems) {
            if (filterItem.evaluate(row)) continue;
            return false;
        }
        return true;
    }

    protected boolean isTruncateTableOperation() {
        List<FilterItem> whereItems = this.getWhereItems();
        return whereItems.isEmpty();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        return "DELETE FROM " + this._table.getQualifiedLabel() + new FilterClause(null, " WHERE ").addItems(this._whereItems);
    }
}

