/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.query.AbstractQueryClause;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

public class FilterClause
extends AbstractQueryClause<FilterItem> {
    private static final long serialVersionUID = -9077342278766808934L;

    public FilterClause(Query query, String prefix) {
        super(query, prefix, " AND ");
    }

    public List<SelectItem> getEvaluatedSelectItems() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        List items = this.getItems();
        for (FilterItem item : items) {
            this.addEvaluatedSelectItems(result, item);
        }
        return result;
    }

    private void addEvaluatedSelectItems(List<SelectItem> result, FilterItem item) {
        Object operand;
        SelectItem selectItem;
        FilterItem[] orItems = item.getChildItems();
        if (orItems != null) {
            for (FilterItem filterItem : orItems) {
                this.addEvaluatedSelectItems(result, filterItem);
            }
        }
        if ((selectItem = item.getSelectItem()) != null && !result.contains(selectItem)) {
            result.add(selectItem);
        }
        if ((operand = item.getOperand()) != null && operand instanceof SelectItem && !result.contains(operand)) {
            result.add((SelectItem)operand);
        }
    }

    public boolean isColumnReferenced(Column column) {
        for (FilterItem item : this.getItems()) {
            if (!item.isReferenced(column)) continue;
            return true;
        }
        return false;
    }
}

