/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.List;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.util.BaseObject;

public class OrderByItem
extends BaseObject
implements QueryItem,
Cloneable {
    private static final long serialVersionUID = -8397473619828484774L;
    private final SelectItem _selectItem;
    private Direction _direction;
    private Query _query;

    public OrderByItem(SelectItem selectItem, Direction direction) {
        if (selectItem == null) {
            throw new IllegalArgumentException("SelectItem cannot be null");
        }
        this._selectItem = selectItem;
        this._direction = direction;
    }

    @Deprecated
    public OrderByItem(SelectItem selectItem, boolean ascending) {
        if (selectItem == null) {
            throw new IllegalArgumentException("SelectItem cannot be null");
        }
        this._selectItem = selectItem;
        this._direction = ascending ? Direction.ASC : Direction.DESC;
    }

    public OrderByItem(SelectItem selectItem) {
        this(selectItem, Direction.ASC);
    }

    @Override
    public String toSql(boolean includeSchemaInColumnPaths) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._selectItem.getSameQueryAlias(includeSchemaInColumnPaths) + ' ');
        sb.append((Object)this._direction);
        return sb.toString();
    }

    @Override
    public String toSql() {
        return this.toSql(false);
    }

    public boolean isAscending() {
        return this._direction == Direction.ASC;
    }

    public boolean isDescending() {
        return this._direction == Direction.DESC;
    }

    public Direction getDirection() {
        return this._direction;
    }

    public OrderByItem setDirection(Direction direction) {
        this._direction = direction;
        return this;
    }

    public SelectItem getSelectItem() {
        return this._selectItem;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public OrderByItem setQuery(Query query) {
        this._query = query;
        if (this._selectItem != null) {
            this._selectItem.setQuery(query);
        }
        return this;
    }

    protected OrderByItem clone() {
        OrderByItem o = new OrderByItem(this._selectItem.clone());
        o._direction = this._direction;
        return o;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add((Object)this._direction);
        identifiers.add(this._selectItem);
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

