/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.builder;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.CompiledQuery;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.ColumnSelectBuilder;
import org.eobjects.metamodel.query.builder.ColumnSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.CountSelectBuilder;
import org.eobjects.metamodel.query.builder.CountSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.FunctionSelectBuilder;
import org.eobjects.metamodel.query.builder.FunctionSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.GroupedQueryBuilder;
import org.eobjects.metamodel.query.builder.HavingBuilder;
import org.eobjects.metamodel.query.builder.HavingBuilderImpl;
import org.eobjects.metamodel.query.builder.SatisfiedOrderByBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedOrderByBuilderImpl;
import org.eobjects.metamodel.query.builder.SatisfiedQueryBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedSelectBuilder;
import org.eobjects.metamodel.query.builder.SatisfiedSelectBuilderImpl;
import org.eobjects.metamodel.query.builder.WhereBuilder;
import org.eobjects.metamodel.query.builder.WhereBuilderImpl;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GroupedQueryBuilderImpl
extends BaseObject
implements GroupedQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GroupedQueryBuilderImpl.class);
    private final Query _query;
    private final DataContext _dataContext;

    public GroupedQueryBuilderImpl(DataContext dataContext, Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        this._dataContext = dataContext;
        this._query = query;
    }

    @Override
    public ColumnSelectBuilder<GroupedQueryBuilder> select(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new ColumnSelectBuilderImpl(column, this._query, this);
    }

    @Override
    public FunctionSelectBuilder<GroupedQueryBuilder> select(FunctionType function, Column column) {
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new FunctionSelectBuilderImpl(function, column, this._query, this);
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> where(FilterItem ... filters) {
        this._query.where(filters);
        return this;
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> where(Iterable<FilterItem> filters) {
        this._query.where(filters);
        return this;
    }

    @Override
    public ColumnSelectBuilder<GroupedQueryBuilder> select(String columnName) {
        Column column = this.findColumn(columnName);
        return this.select(column);
    }

    @Override
    public CountSelectBuilder<GroupedQueryBuilder> selectCount() {
        return new CountSelectBuilderImpl(this._query, this);
    }

    @Override
    public SatisfiedSelectBuilder<GroupedQueryBuilder> select(Column ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        this._query.select(columns);
        return new SatisfiedSelectBuilderImpl(this);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> where(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new WhereBuilderImpl(column, this._query, this);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> where(String columnName) {
        Column column = this.findColumn(columnName);
        return this.where(column);
    }

    @Override
    public Column findColumn(String columnName) throws IllegalArgumentException {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName cannot be null");
        }
        List fromItems = this._query.getFromClause().getItems();
        List selectItems = this._query.getSelectClause().getItems();
        int dotIndex = columnName.indexOf(46);
        if (dotIndex != -1) {
            String aliasPart = columnName.substring(0, dotIndex);
            String columnPart = columnName.substring(dotIndex + 1);
            for (FromItem fromItem : fromItems) {
                Column column = null;
                if ((column = this.findColumnInAliasedTable(column, fromItem, aliasPart, columnPart)) == null) continue;
                return column;
            }
        }
        for (SelectItem item : selectItems) {
            Column column = item.getColumn();
            if (column == null || !columnName.equals(column.getName())) continue;
            return column;
        }
        for (FromItem fromItem : fromItems) {
            Column column;
            Table table = fromItem.getTable();
            if (table == null || (column = table.getColumnByName(columnName)) == null) continue;
            return column;
        }
        Column column = this._dataContext.getColumnByQualifiedLabel(columnName);
        if (column != null) {
            return column;
        }
        IllegalArgumentException exception = new IllegalArgumentException("Could not find column: " + columnName);
        if (logger.isDebugEnabled()) {
            logger.debug("findColumn('" + columnName + "') could not resolve a column", (Throwable)exception);
            for (FromItem fromItem : fromItems) {
                Table table = fromItem.getTable();
                if (table == null) continue;
                logger.debug("Table available in FROM item: {}. Column names: {}", (Object)table, (Object)Arrays.toString(table.getColumnNames()));
            }
        }
        throw exception;
    }

    private Column findColumnInAliasedTable(Column column, FromItem fromItem, String aliasPart, String columnPart) {
        if (column != null) {
            return column;
        }
        Table table = fromItem.getTable();
        if (table != null) {
            String alias = fromItem.getAlias();
            if (alias != null && alias.equals(aliasPart)) {
                column = table.getColumnByName(columnPart);
            }
        } else {
            Query subQuery;
            FromItem leftSide = fromItem.getLeftSide();
            column = this.findColumnInAliasedTable(column, leftSide, aliasPart, columnPart);
            FromItem rightSide = fromItem.getRightSide();
            if ((column = this.findColumnInAliasedTable(column, rightSide, aliasPart, columnPart)) != null && (subQuery = fromItem.getSubQuery()) != null) {
                List items = subQuery.getFromClause().getItems();
                for (FromItem subQueryFromItem : items) {
                    column = this.findColumnInAliasedTable(column, subQueryFromItem, aliasPart, columnPart);
                }
            }
        }
        return column;
    }

    @Override
    public SatisfiedOrderByBuilder<GroupedQueryBuilder> orderBy(String columnName) {
        return this.orderBy(this.findColumn(columnName));
    }

    @Override
    public SatisfiedOrderByBuilder<GroupedQueryBuilder> orderBy(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new SatisfiedOrderByBuilderImpl(column, this._query, this);
    }

    @Override
    public SatisfiedOrderByBuilder<GroupedQueryBuilder> orderBy(FunctionType function, Column column) {
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new SatisfiedOrderByBuilderImpl(function, column, this._query, this);
    }

    @Override
    public GroupedQueryBuilder groupBy(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        this._query.groupBy(column);
        return this;
    }

    @Override
    public GroupedQueryBuilder groupBy(String columnName) {
        Column column = this.findColumn(columnName);
        return this.groupBy(column);
    }

    @Override
    public GroupedQueryBuilder groupBy(Column ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns cannot be null");
        }
        this._query.groupBy(columns);
        return this;
    }

    @Override
    public HavingBuilder having(FunctionType function, Column column) {
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return new HavingBuilderImpl(function, column, this._query, this);
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> limit(int maxRows) {
        this._query.setMaxRows(maxRows);
        return this;
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> maxRows(int maxRows) {
        this._query.setMaxRows(maxRows);
        return this;
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> firstRow(int firstRow) {
        if (firstRow >= 0) {
            this._query.setFirstRow(firstRow);
        } else {
            this._query.setFirstRow(null);
        }
        return this;
    }

    @Override
    public SatisfiedQueryBuilder<GroupedQueryBuilder> offset(int offset) {
        if (offset >= 0) {
            this._query.setFirstRow(offset + 1);
        } else {
            this._query.setFirstRow(null);
        }
        return this;
    }

    @Override
    public String toString() {
        return this._query.toSql();
    }

    @Override
    public Query toQuery() {
        return this._query.clone();
    }

    @Override
    public CompiledQuery compile() {
        return this._dataContext.compileQuery(this._query);
    }

    @Override
    public DataSet execute() {
        return this._dataContext.executeQuery(this._query);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._query);
    }
}

