/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.builder;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.builder.InitFromBuilder;
import org.eobjects.metamodel.query.builder.TableFromBuilder;
import org.eobjects.metamodel.query.builder.TableFromBuilderImpl;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.BaseObject;

public final class InitFromBuilderImpl
extends BaseObject
implements InitFromBuilder {
    private DataContext dataContext;
    private Query query;

    public InitFromBuilderImpl(DataContext dataContext) {
        this.dataContext = dataContext;
        this.query = new Query();
    }

    @Override
    public TableFromBuilder from(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new TableFromBuilderImpl(table, this.query, this.dataContext);
    }

    @Override
    public TableFromBuilder from(String schemaName, String tableName) {
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName cannot be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        Schema schema = this.dataContext.getSchemaByName(schemaName);
        if (schema == null) {
            schema = this.dataContext.getDefaultSchema();
        }
        return this.from(schema, tableName);
    }

    @Override
    public TableFromBuilder from(Schema schema, String tableName) {
        Table table = schema.getTableByName(tableName);
        if (table == null) {
            throw new IllegalArgumentException("Nu such table '" + tableName + "' found in schema: " + schema + ". Available tables are: " + Arrays.toString(schema.getTableNames()));
        }
        return this.from(table);
    }

    @Override
    public TableFromBuilder from(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        Table table = this.dataContext.getTableByQualifiedLabel(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        return this.from(table);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.query);
    }
}

