/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public abstract class AbstractColumn
implements Column {
    private static final long serialVersionUID = 1L;

    @Override
    public final String getQuotedName() {
        String quote = this.getQuote();
        if (quote == null) {
            return this.getName();
        }
        return quote + this.getName() + quote;
    }

    @Override
    public final String getQualifiedLabel() {
        StringBuilder sb = new StringBuilder();
        Table table = this.getTable();
        if (table != null) {
            sb.append(table.getQualifiedLabel());
            sb.append('.');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public final int compareTo(Column that) {
        int diff = this.getQualifiedLabel().compareTo(that.getQualifiedLabel());
        if (diff == 0) {
            diff = this.toString().compareTo(that.toString());
        }
        return diff;
    }

    public final String toString() {
        return "Column[name=" + this.getName() + ",columnNumber=" + this.getColumnNumber() + ",type=" + (Object)((Object)this.getType()) + ",nullable=" + this.isNullable() + ",nativeType=" + this.getNativeType() + ",columnSize=" + this.getColumnSize() + "]";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column other = (Column)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            Table table1 = this.getTable();
            Table table2 = other.getTable();
            return !(table1 == null ? table2 != null : !table1.equals(table2));
        }
        return false;
    }
}

