/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.io.Serializable;
import org.eobjects.metamodel.schema.AbstractRelationship;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableRelationship
extends AbstractRelationship
implements Serializable,
Relationship {
    private static final long serialVersionUID = 238786848828528822L;
    private static final Logger logger = LoggerFactory.getLogger(MutableRelationship.class);
    private final Column[] _primaryColumns;
    private final Column[] _foreignColumns;

    public static Relationship createRelationship(Column[] primaryColumns, Column[] foreignColumns) {
        Table primaryTable = MutableRelationship.checkSameTable(primaryColumns);
        Table foreignTable = MutableRelationship.checkSameTable(foreignColumns);
        MutableRelationship relation = new MutableRelationship(primaryColumns, foreignColumns);
        if (primaryTable instanceof MutableTable) {
            try {
                ((MutableTable)primaryTable).addRelationship(relation);
            }
            catch (UnsupportedOperationException e) {
                logger.debug("primary table ({}) threw exception when adding relationship", (Object)primaryTable);
            }
            if (foreignTable != primaryTable && foreignTable instanceof MutableTable) {
                try {
                    ((MutableTable)foreignTable).addRelationship(relation);
                }
                catch (UnsupportedOperationException e) {
                    logger.debug("foreign table ({}) threw exception when adding relationship", (Object)foreignTable);
                }
            }
        }
        return relation;
    }

    public void remove() {
        Table foreignTable;
        Table primaryTable = this.getPrimaryTable();
        if (primaryTable instanceof MutableTable) {
            ((MutableTable)primaryTable).removeRelationship(this);
        }
        if ((foreignTable = this.getForeignTable()) instanceof MutableTable) {
            ((MutableTable)foreignTable).removeRelationship(this);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.remove();
    }

    public static Relationship createRelationship(Column primaryColumn, Column foreignColumn) {
        return MutableRelationship.createRelationship(new Column[]{primaryColumn}, new Column[]{foreignColumn});
    }

    private MutableRelationship(Column[] primaryColumns, Column[] foreignColumns) {
        this._primaryColumns = primaryColumns;
        this._foreignColumns = foreignColumns;
    }

    @Override
    public Column[] getPrimaryColumns() {
        return this._primaryColumns;
    }

    @Override
    public Column[] getForeignColumns() {
        return this._foreignColumns;
    }
}

