/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.update;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.data.AbstractRowBuilder;
import org.eobjects.metamodel.query.FilterClause;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.AbstractFilterBuilder;
import org.eobjects.metamodel.query.builder.FilterBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;

public abstract class AbstractRowUpdationBuilder
extends AbstractRowBuilder<RowUpdationBuilder>
implements RowUpdationBuilder {
    private final Table _table;
    private final List<FilterItem> _whereItems;

    public AbstractRowUpdationBuilder(Table table) {
        super(table);
        this._table = table;
        this._whereItems = new ArrayList<FilterItem>();
    }

    protected List<FilterItem> getWhereItems() {
        return this._whereItems;
    }

    @Override
    public FilterBuilder<RowUpdationBuilder> where(Column column) {
        SelectItem selectItem = new SelectItem(column);
        return new AbstractFilterBuilder<RowUpdationBuilder>(selectItem){

            @Override
            protected RowUpdationBuilder applyFilter(FilterItem filter) {
                return AbstractRowUpdationBuilder.this.where(filter);
            }
        };
    }

    @Override
    public FilterBuilder<RowUpdationBuilder> where(String columnName) {
        Column column = this._table.getColumnByName(columnName);
        if (column == null) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        return this.where(column);
    }

    @Override
    public RowUpdationBuilder where(FilterItem ... filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }

    @Override
    public RowUpdationBuilder where(Iterable<FilterItem> filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this._table.getQualifiedLabel());
        sb.append(" SET ");
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(columns[i].getName());
            sb.append('=');
            sb.append(values[i] == null ? "NULL" : values[i].toString());
        }
        List<FilterItem> whereItems = this.getWhereItems();
        String whereClause = new FilterClause(null, " WHERE ").addItems(whereItems).toSql();
        sb.append(whereClause);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

