/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseObject {
    private static final Logger logger = LoggerFactory.getLogger(BaseObject.class);

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public final int hashCode() {
        logger.debug("{}.hashCode()", (Object)this);
        int hashCode = -1;
        ArrayList<Object> list = new ArrayList<Object>();
        this.decorateIdentity(list);
        if (list.isEmpty()) {
            list.add(this.toString());
        }
        hashCode -= list.size();
        for (Object e : list) {
            hashCode += BaseObject.hashCode(e);
        }
        return hashCode;
    }

    private static final int hashCode(Object obj) {
        if (obj == null) {
            logger.debug("obj is null, returning constant");
            return -17;
        }
        if (obj.getClass().isArray()) {
            logger.debug("obj is an array, returning a sum");
            int length = Array.getLength(obj);
            int hashCode = 4324;
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(obj, i);
                hashCode += BaseObject.hashCode(o);
            }
            return hashCode;
        }
        logger.debug("obj is a regular object, returning hashCode");
        return obj.hashCode();
    }

    protected boolean classEquals(BaseObject obj) {
        return this.getClass() == obj.getClass();
    }

    public final boolean equals(Object obj) {
        BaseObject that;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BaseObject && this.classEquals(that = (BaseObject)obj)) {
            ArrayList<Object> list1 = new ArrayList<Object>();
            ArrayList<Object> list2 = new ArrayList<Object>();
            this.decorateIdentity(list1);
            that.decorateIdentity(list2);
            if (list1.size() != list2.size()) {
                throw new IllegalStateException("Two instances of the same class (" + this.getClass().getName() + ") returned different size decorated identity lists");
            }
            if (list1.isEmpty()) {
                assert (list2.isEmpty());
                list1.add(this.toString());
                list2.add(that.toString());
            }
            EqualsBuilder eb = new EqualsBuilder();
            Iterator it1 = list1.iterator();
            Iterator it2 = list2.iterator();
            while (it1.hasNext()) {
                assert (it2.hasNext());
                Object next1 = it1.next();
                Object next2 = it2.next();
                eb.append(next1, next2);
            }
            assert (!it2.hasNext());
            return eb.isEquals();
        }
        return false;
    }

    protected abstract void decorateIdentity(List<Object> var1);
}

