/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.Ref;
import org.eobjects.metamodel.util.SharedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyRef<E>
implements Ref<E> {
    private static final Logger logger = LoggerFactory.getLogger(LazyRef.class);
    private final AtomicBoolean _fetched = new AtomicBoolean(false);
    private volatile Throwable _error;
    private E _object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E get() {
        if (!this._fetched.get()) {
            AtomicBoolean atomicBoolean = this._fetched;
            synchronized (atomicBoolean) {
                if (!this._fetched.get()) {
                    try {
                        this._object = this.fetch();
                    }
                    catch (Throwable t) {
                        this._error = t;
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        logger.warn("Failed to fetch value: " + this + ". Reporting error.", t);
                    }
                    finally {
                        this._fetched.set(true);
                    }
                }
            }
        }
        return this._object;
    }

    protected abstract E fetch() throws Throwable;

    public boolean isFetched() {
        return this._fetched.get();
    }

    public Throwable getError() {
        return this._error;
    }

    public void requestLoad(final Action<Throwable> errorAction) {
        if (!this.isFetched()) {
            ExecutorService executorService = SharedExecutorService.get();
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        LazyRef.this.get();
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    if (LazyRef.this._error != null && errorAction != null) {
                        try {
                            errorAction.run(LazyRef.this._error);
                        }
                        catch (Exception e) {
                            logger.error("Error handling action failed!", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void requestLoad() {
        this.requestLoad(null);
    }
}

