/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.Serializable;
import java.util.Arrays;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.HasName;

public class SimpleTableDef
implements Serializable,
HasName {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final String[] _columnNames;
    private final ColumnType[] _columnTypes;

    public SimpleTableDef(Table table) {
        this._name = table.getName();
        this._columnNames = new String[table.getColumnCount()];
        this._columnTypes = new ColumnType[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            Column column = table.getColumn(i);
            this._columnNames[i] = column.getName();
            this._columnTypes[i] = column.getType();
        }
    }

    public SimpleTableDef(String name, String[] columnNames) {
        this(name, columnNames, null);
    }

    public SimpleTableDef(String name, String[] columnNames, ColumnType[] columnTypes) {
        this._name = name;
        this._columnNames = columnNames;
        if (columnTypes == null) {
            columnTypes = new ColumnType[columnNames.length];
            for (int i = 0; i < columnTypes.length; ++i) {
                columnTypes[i] = ColumnType.VARCHAR;
            }
        } else if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("Property names and column types cannot have different lengths (found " + columnNames.length + " and " + columnTypes.length + ")");
        }
        this._columnTypes = columnTypes;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public ColumnType[] getColumnTypes() {
        return this._columnTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this._columnTypes);
        result = 31 * result + Arrays.hashCode(this._columnNames);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTableDef other = (SimpleTableDef)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (!Arrays.equals((Object[])this._columnTypes, (Object[])other._columnTypes)) {
            return false;
        }
        return Arrays.equals(this._columnNames, other._columnNames);
    }

    public String toString() {
        return "SimpleDbTableDef[name=" + this._name + ",columnNames=" + Arrays.toString(this._columnNames) + ",columnTypes=" + Arrays.toString((Object[])this._columnTypes) + "]";
    }

    public MutableTable toTable() {
        String name = this.getName();
        String[] columnNames = this.getColumnNames();
        ColumnType[] columnTypes = this.getColumnTypes();
        MutableTable table = new MutableTable(name, TableType.TABLE);
        for (int i = 0; i < columnNames.length; ++i) {
            table.addColumn(new MutableColumn(columnNames[i], columnTypes[i], table, i, true));
        }
        return table;
    }

    public int indexOf(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name cannot be null");
        }
        for (int i = 0; i < this._columnNames.length; ++i) {
            if (!columnName.equals(this._columnNames[i])) continue;
            return i;
        }
        return -1;
    }
}

