/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.ResourceException;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URI _uri;

    public UrlResource(URL url) {
        try {
            this._uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public UrlResource(URI uri) {
        this._uri = uri;
    }

    public UrlResource(String urlString) {
        try {
            this._uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "UrlResource[" + this._uri + "]";
    }

    public URI getUri() {
        return this._uri;
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._uri.toString();
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void append(Action<OutputStream> appendCallback) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void read(Action<InputStream> readCallback) throws ResourceException {
        InputStream in = this.read();
        try {
            readCallback.run(in);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
    }

    @Override
    public <E> E read(Func<InputStream, E> readCallback) throws ResourceException {
        E e;
        InputStream in = this.read();
        try {
            E result;
            e = result = readCallback.eval(in);
        }
        catch (Exception e2) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e2);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
        return e;
    }

    @Override
    public boolean isExists() {
        return true;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getLastModified() {
        return -1L;
    }

    @Override
    public InputStream read() throws ResourceException {
        try {
            return this._uri.toURL().openStream();
        }
        catch (Exception e) {
            throw new ResourceException(this, "Failed to open InputStream", e);
        }
    }
}

