/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel;

import java.util.List;
import java.util.ListIterator;
import org.eobjects.metamodel.AbstractUpdateCallback;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.AbstractRowUpdationBuilder;

public class DeleteAndInsertBuilder
extends AbstractRowUpdationBuilder {
    private final AbstractUpdateCallback _updateCallback;

    public DeleteAndInsertBuilder(AbstractUpdateCallback updateCallback, Table table) {
        super(table);
        assert (updateCallback.isInsertSupported());
        assert (updateCallback.isDeleteSupported());
        this._updateCallback = updateCallback;
    }

    @Override
    public void execute() throws MetaModelException {
        List<Row> rows = this.getRowsToUpdate();
        ((RowDeletionBuilder)this._updateCallback.deleteFrom(this.getTable()).where(this.getWhereItems())).execute();
        rows = this.updateRows(rows);
        for (Row row : rows) {
            this._updateCallback.insertInto(this.getTable()).like(row).execute();
        }
    }

    private List<Row> updateRows(List<Row> rows) {
        ListIterator<Row> it = rows.listIterator();
        while (it.hasNext()) {
            Row original = it.next();
            Row updated = this.update(original);
            it.set(updated);
        }
        return rows;
    }

    private Row update(Row original) {
        SelectItem[] items = original.getSelectItems();
        Object[] values = new Object[items.length];
        for (int i = 0; i < items.length; ++i) {
            Column column = items[i].getColumn();
            Object value = this.isSet(column) ? this.getValues()[i] : original.getValue(i);
            values[i] = value;
        }
        return new DefaultRow(new SimpleDataSetHeader(items), values);
    }

    protected List<Row> getRowsToUpdate() {
        DataContext dc = this._updateCallback.getDataContext();
        Table table = this.getTable();
        List<FilterItem> whereItems = this.getWhereItems();
        DataSet dataSet = dc.query().from(table).select(table.getColumns()).where(whereItems).execute();
        List<Row> rows = dataSet.toRows();
        return rows;
    }
}

