/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.create;

import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.create.ColumnCreationBuilder;
import org.eobjects.metamodel.create.ColumnCreationBuilderImpl;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableCreationBuilder<U extends UpdateCallback>
implements TableCreationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTableCreationBuilder.class);
    private final U _updateCallback;
    private final MutableTable _table;
    private final Schema _schema;

    public AbstractTableCreationBuilder(U updateCallback, Schema schema, String name) {
        if (schema != null && schema.getTableByName(name) != null) {
            throw new IllegalArgumentException("A table with the name '" + name + "' already exists in schema: " + schema);
        }
        this._updateCallback = updateCallback;
        this._schema = schema;
        this._table = new MutableTable(name, TableType.TABLE, schema);
    }

    protected U getUpdateCallback() {
        return this._updateCallback;
    }

    protected Schema getSchema() {
        return this._schema;
    }

    protected MutableTable getTable() {
        return this._table;
    }

    @Override
    public Table toTable() {
        return this._table;
    }

    @Override
    public TableCreationBuilder like(Table table) {
        Column[] columns;
        logger.debug("like({})", (Object)table);
        for (Column column : columns = table.getColumns()) {
            this.withColumn(column.getName()).like(column);
        }
        return this;
    }

    @Override
    public ColumnCreationBuilder withColumn(String name) {
        logger.debug("withColumn({})", (Object)name);
        MutableColumn col = (MutableColumn)this._table.getColumnByName(name);
        if (col == null) {
            col = new MutableColumn(name).setTable(this._table).setColumnNumber(this._table.getColumnCount());
            this._table.addColumn(col);
        }
        return new ColumnCreationBuilderImpl(this, col);
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this._table.getQualifiedLabel());
        sb.append(" (");
        Column[] columns = this._table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            Column column = columns[i];
            sb.append(column.getName());
            ColumnType type = column.getType();
            if (type != null) {
                sb.append(' ');
                sb.append(type.toString());
                Integer columnSize = column.getColumnSize();
                if (columnSize != null) {
                    sb.append('(');
                    sb.append(columnSize);
                    sb.append(')');
                }
            }
            if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                sb.append(" NOT NULL");
            }
            if (!column.isPrimaryKey()) continue;
            sb.append(" PRIMARY KEY");
        }
        sb.append(")");
        return sb.toString();
    }
}

