/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.data;

import java.util.Arrays;
import java.util.List;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.CachingDataSetHeader;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.EmptyDataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.data.SimpleDataSetHeader;
import org.eobjects.metamodel.query.SelectItem;

public final class InMemoryDataSet
extends AbstractDataSet {
    private final List<Row> _rows;
    private int _rowNumber = -1;

    public InMemoryDataSet(Row ... rows) {
        this(Arrays.asList(rows));
    }

    public InMemoryDataSet(List<Row> rows) {
        this(InMemoryDataSet.getHeader(rows), rows);
    }

    public InMemoryDataSet(DataSetHeader header, Row ... rows) {
        super(header);
        this._rows = Arrays.asList(rows);
    }

    public InMemoryDataSet(DataSetHeader header, List<Row> rows) {
        super(header);
        this._rows = rows;
    }

    private static DataSetHeader getHeader(List<Row> rows) {
        if (rows.isEmpty()) {
            throw new IllegalArgumentException("Cannot hold an empty list of rows, use " + EmptyDataSet.class + " for this");
        }
        SelectItem[] selectItems = rows.get(0).getSelectItems();
        if (rows.size() > 3) {
            return new SimpleDataSetHeader(selectItems);
        }
        return new CachingDataSetHeader(selectItems);
    }

    @Override
    public boolean next() {
        ++this._rowNumber;
        return this._rowNumber < this._rows.size();
    }

    @Override
    public Row getRow() {
        if (this._rowNumber < 0 || this._rowNumber >= this._rows.size()) {
            return null;
        }
        Row row = this._rows.get(this._rowNumber);
        assert (row.size() == this.getHeader().size());
        return row;
    }

    public List<Row> getRows() {
        return this._rows;
    }

    public int size() {
        return this._rows.size();
    }
}

