/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.intercept;

import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.delete.RowDeletionBuilder;
import org.eobjects.metamodel.drop.TableDropBuilder;
import org.eobjects.metamodel.insert.RowInsertionBuilder;
import org.eobjects.metamodel.intercept.DataSetInterceptor;
import org.eobjects.metamodel.intercept.InterceptableUpdateScript;
import org.eobjects.metamodel.intercept.InterceptorList;
import org.eobjects.metamodel.intercept.QueryInterceptor;
import org.eobjects.metamodel.intercept.RowDeletionInterceptor;
import org.eobjects.metamodel.intercept.RowInsertionInterceptor;
import org.eobjects.metamodel.intercept.RowUpdationInterceptor;
import org.eobjects.metamodel.intercept.SchemaInterceptor;
import org.eobjects.metamodel.intercept.TableCreationInterceptor;
import org.eobjects.metamodel.intercept.TableDropInterceptor;
import org.eobjects.metamodel.query.CompiledQuery;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.builder.InitFromBuilder;
import org.eobjects.metamodel.query.builder.InitFromBuilderImpl;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;
import org.eobjects.metamodel.util.HasNameMapper;

public class InterceptableDataContext
implements UpdateableDataContext {
    private final DataContext _delegate;
    private final InterceptorList<DataSet> _dataSetInterceptors;
    private final InterceptorList<Query> _queryInterceptors;
    private final InterceptorList<Schema> _schemaInterceptors;
    private final InterceptorList<RowInsertionBuilder> _rowInsertionInterceptors;
    private final InterceptorList<RowUpdationBuilder> _rowUpdationInterceptors;
    private final InterceptorList<RowDeletionBuilder> _rowDeletionInterceptors;
    private final InterceptorList<TableCreationBuilder> _tableCreationInterceptors;
    private final InterceptorList<TableDropBuilder> _tableDropInterceptors;

    protected InterceptableDataContext(DataContext delegate) {
        this._delegate = delegate;
        this._dataSetInterceptors = new InterceptorList();
        this._queryInterceptors = new InterceptorList();
        this._schemaInterceptors = new InterceptorList();
        this._rowInsertionInterceptors = new InterceptorList();
        this._rowUpdationInterceptors = new InterceptorList();
        this._rowDeletionInterceptors = new InterceptorList();
        this._tableCreationInterceptors = new InterceptorList();
        this._tableDropInterceptors = new InterceptorList();
    }

    public InterceptableDataContext addTableCreationInterceptor(TableCreationInterceptor interceptor) {
        this._tableCreationInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeTableCreationInterceptor(TableCreationInterceptor interceptor) {
        this._tableCreationInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addTableDropInterceptor(TableDropInterceptor interceptor) {
        this._tableDropInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeTableDropInterceptor(TableDropInterceptor interceptor) {
        this._tableDropInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowInsertionInterceptor(RowInsertionInterceptor interceptor) {
        this._rowInsertionInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowInsertionInterceptor(RowInsertionInterceptor interceptor) {
        this._rowInsertionInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowUpdationInterceptor(RowUpdationInterceptor interceptor) {
        this._rowUpdationInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowUpdationInterceptor(RowUpdationInterceptor interceptor) {
        this._rowUpdationInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowDeletionInterceptor(RowDeletionInterceptor interceptor) {
        this._rowDeletionInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowDeletionInterceptor(RowDeletionInterceptor interceptor) {
        this._rowDeletionInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addQueryInterceptor(QueryInterceptor interceptor) {
        this._queryInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeQueryInterceptor(QueryInterceptor interceptor) {
        this._queryInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addSchemaInterceptor(SchemaInterceptor interceptor) {
        this._schemaInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeSchemaInterceptor(SchemaInterceptor interceptor) {
        this._schemaInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addDataSetInterceptor(DataSetInterceptor interceptor) {
        this._dataSetInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeDataSetInterceptor(DataSetInterceptor interceptor) {
        this._dataSetInterceptors.remove(interceptor);
        return this;
    }

    public InterceptorList<DataSet> getDataSetInterceptors() {
        return this._dataSetInterceptors;
    }

    public InterceptorList<Query> getQueryInterceptors() {
        return this._queryInterceptors;
    }

    public InterceptorList<RowInsertionBuilder> getRowInsertionInterceptors() {
        return this._rowInsertionInterceptors;
    }

    public InterceptorList<RowUpdationBuilder> getRowUpdationInterceptors() {
        return this._rowUpdationInterceptors;
    }

    public InterceptorList<RowDeletionBuilder> getRowDeletionInterceptors() {
        return this._rowDeletionInterceptors;
    }

    public InterceptorList<Schema> getSchemaInterceptors() {
        return this._schemaInterceptors;
    }

    public InterceptorList<TableCreationBuilder> getTableCreationInterceptors() {
        return this._tableCreationInterceptors;
    }

    public DataContext getDelegate() {
        return this._delegate;
    }

    @Override
    public DataSet executeQuery(Query query) throws MetaModelException {
        query = this._queryInterceptors.interceptAll(query);
        DataSet dataSet = this._delegate.executeQuery(query);
        dataSet = this._dataSetInterceptors.interceptAll(dataSet);
        return dataSet;
    }

    @Override
    public UpdateableDataContext refreshSchemas() {
        this._delegate.refreshSchemas();
        return this;
    }

    @Override
    public Schema[] getSchemas() throws MetaModelException {
        Schema[] schemas = this._delegate.getSchemas();
        if (!this._schemaInterceptors.isEmpty()) {
            for (int i = 0; i < schemas.length; ++i) {
                schemas[i] = this._schemaInterceptors.interceptAll(schemas[i]);
            }
        }
        return schemas;
    }

    @Override
    public String[] getSchemaNames() throws MetaModelException {
        if (this._schemaInterceptors.isEmpty()) {
            return this._delegate.getSchemaNames();
        }
        Schema[] schemas = this.getSchemas();
        String[] schemaNames = new String[schemas.length];
        for (int i = 0; i < schemaNames.length; ++i) {
            schemaNames[i] = new HasNameMapper().eval(schemas[i]);
        }
        return schemaNames;
    }

    @Override
    public Schema getDefaultSchema() throws MetaModelException {
        Schema schema = this._delegate.getDefaultSchema();
        schema = this._schemaInterceptors.interceptAll(schema);
        return schema;
    }

    @Override
    public Schema getSchemaByName(String name) throws MetaModelException {
        Schema schema = this._delegate.getSchemaByName(name);
        schema = this._schemaInterceptors.interceptAll(schema);
        return schema;
    }

    @Override
    public InitFromBuilder query() {
        return new InitFromBuilderImpl(this);
    }

    @Override
    public Column getColumnByQualifiedLabel(String columnName) {
        return this._delegate.getColumnByQualifiedLabel(columnName);
    }

    @Override
    public Table getTableByQualifiedLabel(String tableName) {
        return this._delegate.getTableByQualifiedLabel(tableName);
    }

    @Override
    public void executeUpdate(UpdateScript update) {
        if (!(this._delegate instanceof UpdateableDataContext)) {
            throw new UnsupportedOperationException("Delegate is not an UpdateableDataContext");
        }
        UpdateableDataContext delegate = (UpdateableDataContext)this._delegate;
        if (this._tableCreationInterceptors.isEmpty() && this._tableDropInterceptors.isEmpty() && this._rowInsertionInterceptors.isEmpty() && this._rowUpdationInterceptors.isEmpty() && this._rowDeletionInterceptors.isEmpty()) {
            delegate.executeUpdate(update);
            return;
        }
        InterceptableUpdateScript interceptableUpdateScript = new InterceptableUpdateScript(this, update, this._tableCreationInterceptors, this._tableDropInterceptors, this._rowInsertionInterceptors, this._rowUpdationInterceptors, this._rowDeletionInterceptors);
        delegate.executeUpdate(interceptableUpdateScript);
    }

    @Override
    public Query parseQuery(String queryString) throws MetaModelException {
        return this._delegate.parseQuery(queryString);
    }

    @Override
    public DataSet executeQuery(String queryString) throws MetaModelException {
        Query query = this.parseQuery(queryString);
        DataSet dataSet = this.executeQuery(query);
        return dataSet;
    }

    @Override
    public CompiledQuery compileQuery(Query query) {
        return this._delegate.compileQuery(query);
    }

    @Override
    public DataSet executeQuery(CompiledQuery compiledQuery, Object ... values) {
        return this._delegate.executeQuery(compiledQuery, values);
    }
}

