/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.metamodel.query.CompiledQuery;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.QueryParameter;

public class DefaultCompiledQuery
implements CompiledQuery {
    private final Query _query;
    private final List<QueryParameter> _parameters;

    public DefaultCompiledQuery(Query query) {
        this._query = query;
        this._parameters = this.createParameterList();
    }

    public Query cloneWithParameterValues(Object[] values) {
        AtomicInteger parameterIndex = new AtomicInteger(0);
        Query clonedQuery = this._query.clone();
        this.replaceParametersInQuery(values, parameterIndex, this._query, clonedQuery);
        return clonedQuery;
    }

    private void replaceParametersInQuery(Object[] values, AtomicInteger parameterIndex, Query originalQuery, Query newQuery) {
        this.replaceParametersInFromClause(values, parameterIndex, originalQuery, newQuery);
        this.replaceParametersInWhereClause(values, parameterIndex, originalQuery, newQuery);
    }

    private void replaceParametersInWhereClause(Object[] values, AtomicInteger parameterIndex, Query originalQuery, Query newQuery) {
        List items = originalQuery.getWhereClause().getItems();
        int i = 0;
        for (FilterItem filterItem : items) {
            FilterItem newFilter;
            if (filterItem != (newFilter = this.copyFilterItem(filterItem, values, parameterIndex))) {
                newQuery.getWhereClause().removeItem(i);
                newQuery.getWhereClause().addItem(i, newFilter);
            }
            ++i;
        }
    }

    private void replaceParametersInFromClause(Object[] values, AtomicInteger parameterIndex, Query originalQuery, Query newQuery) {
        List fromItems = originalQuery.getFromClause().getItems();
        int i = 0;
        for (FromItem fromItem : fromItems) {
            Query subQuery = fromItem.getSubQuery();
            if (subQuery != null) {
                Query newSubQuery = ((FromItem)newQuery.getFromClause().getItem(i)).getSubQuery();
                this.replaceParametersInQuery(values, parameterIndex, subQuery, newSubQuery);
                newQuery.getFromClause().removeItem(i);
                newQuery.getFromClause().addItem(i, new FromItem(newSubQuery).setAlias(fromItem.getAlias()));
            }
            ++i;
        }
    }

    private FilterItem copyFilterItem(FilterItem item, Object[] values, AtomicInteger parameterIndex) {
        if (item.isCompoundFilter()) {
            FilterItem[] childItems = item.getChildItems();
            FilterItem[] newChildItems = new FilterItem[childItems.length];
            for (int i = 0; i < childItems.length; ++i) {
                FilterItem newChildItem;
                FilterItem childItem = childItems[i];
                newChildItems[i] = newChildItem = this.copyFilterItem(childItem, values, parameterIndex);
            }
            FilterItem newFilter = new FilterItem(newChildItems);
            return newFilter;
        }
        if (item.getOperand() instanceof QueryParameter) {
            Object newOperand = values[parameterIndex.getAndIncrement()];
            FilterItem newFilter = new FilterItem(item.getSelectItem(), item.getOperator(), newOperand);
            return newFilter;
        }
        return item;
    }

    private List<QueryParameter> createParameterList() {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        this.buildParameterListInFromClause(parameters, this._query);
        this.buildParameterListInWhereClause(parameters, this._query);
        return parameters;
    }

    private void buildParameterListInWhereClause(List<QueryParameter> parameters, Query query) {
        List items = query.getWhereClause().getItems();
        for (FilterItem item : items) {
            this.buildParameterFromFilterItem(parameters, item);
        }
    }

    private void buildParameterListInFromClause(List<QueryParameter> parameters, Query query) {
        List fromItems = query.getFromClause().getItems();
        for (FromItem fromItem : fromItems) {
            Query subQuery = fromItem.getSubQuery();
            if (subQuery == null) continue;
            this.buildParameterListInFromClause(parameters, subQuery);
            this.buildParameterListInWhereClause(parameters, subQuery);
        }
    }

    @Override
    public List<QueryParameter> getParameters() {
        return this._parameters;
    }

    @Override
    public String toSql() {
        return this._query.toSql();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toSql() + "]";
    }

    @Override
    public void close() {
    }

    private void buildParameterFromFilterItem(List<QueryParameter> parameters, FilterItem item) {
        if (item.isCompoundFilter()) {
            FilterItem[] childItems;
            for (FilterItem childItem : childItems = item.getChildItems()) {
                this.buildParameterFromFilterItem(parameters, childItem);
            }
        } else if (item.getOperand() instanceof QueryParameter) {
            parameters.add((QueryParameter)item.getOperand());
        }
    }
}

