/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import org.eobjects.metamodel.query.AbstractQueryClause;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.JoinType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Table;

public class FromClause
extends AbstractQueryClause<FromItem> {
    private static final long serialVersionUID = -8227310702249122115L;

    public FromClause(Query query) {
        super(query, " FROM ", ", ");
    }

    public String getAlias(Table table) {
        if (table != null) {
            for (FromItem item : this.getItems()) {
                String alias = item.getAlias(table);
                if (alias == null) continue;
                return alias;
            }
        }
        return null;
    }

    public FromItem getItemByReference(String reference) {
        if (reference == null) {
            return null;
        }
        for (FromItem item : this.getItems()) {
            FromItem result = this.getItemByReference(item, reference);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private FromItem getItemByReference(FromItem item, String reference) {
        String alias = item.getAlias();
        if (reference.equals(alias)) {
            return item;
        }
        Table table = item.getTable();
        if (alias == null && table != null && reference.equals(table.getName())) {
            return item;
        }
        JoinType join = item.getJoin();
        if (join != null) {
            FromItem leftResult = this.getItemByReference(item.getLeftSide(), reference);
            if (leftResult != null) {
                return leftResult;
            }
            FromItem rightResult = this.getItemByReference(item.getRightSide(), reference);
            if (rightResult != null) {
                return rightResult;
            }
        }
        return null;
    }
}

