/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import org.eobjects.metamodel.query.AverageAggregateBuilder;
import org.eobjects.metamodel.query.CountAggregateBuilder;
import org.eobjects.metamodel.query.MaxAggregateBuilder;
import org.eobjects.metamodel.query.MinAggregateBuilder;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.SumAggregateBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.util.AggregateBuilder;

public enum FunctionType {
    COUNT{

        public AggregateBuilder<Long> build() {
            return new CountAggregateBuilder();
        }
    }
    ,
    AVG{

        public AggregateBuilder<Double> build() {
            return new AverageAggregateBuilder();
        }
    }
    ,
    SUM{

        public AggregateBuilder<Double> build() {
            return new SumAggregateBuilder();
        }
    }
    ,
    MAX{

        public AggregateBuilder<Object> build() {
            return new MaxAggregateBuilder();
        }
    }
    ,
    MIN{

        public AggregateBuilder<Object> build() {
            return new MinAggregateBuilder();
        }
    };


    public ColumnType getExpectedColumnType(ColumnType type) {
        switch (this) {
            case COUNT: {
                return ColumnType.BIGINT;
            }
            case AVG: 
            case SUM: {
                return ColumnType.DOUBLE;
            }
            case MAX: 
            case MIN: {
                return type;
            }
        }
        return type;
    }

    public SelectItem createSelectItem(Column column) {
        return new SelectItem(this, column);
    }

    public SelectItem createSelectItem(String expression, String alias) {
        return new SelectItem(this, expression, alias);
    }

    public Object evaluate(Iterable<?> values) {
        AggregateBuilder<?> builder = this.build();
        for (Object object : values) {
            builder.add(object);
        }
        return builder.getAggregate();
    }

    public Object evaluate(Object ... values) {
        AggregateBuilder<?> builder = this.build();
        for (Object object : values) {
            builder.add(object);
        }
        return builder.getAggregate();
    }

    public abstract AggregateBuilder<?> build();

    public static FunctionType get(String functionName) {
        try {
            return FunctionType.valueOf(functionName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

