/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query;

import java.util.List;
import org.eobjects.metamodel.query.AbstractQueryClause;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;

public class SelectClause
extends AbstractQueryClause<SelectItem> {
    private static final long serialVersionUID = -2458447191169901181L;
    private boolean _distinct = false;

    public SelectClause(Query query) {
        super(query, "SELECT ", ", ");
    }

    public SelectItem getSelectItem(Column column) {
        if (column != null) {
            for (SelectItem item : this.getItems()) {
                if (!column.equals(item.getColumn())) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public String toSql(boolean includeSchemaInColumnPaths) {
        if (this.getItems().size() == 0) {
            return "";
        }
        String sql = super.toSql(includeSchemaInColumnPaths);
        StringBuilder sb = new StringBuilder(sql);
        if (this._distinct) {
            sb.insert("SELECT ".length(), "DISTINCT ");
        }
        return sb.toString();
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public void setDistinct(boolean distinct) {
        this._distinct = distinct;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._distinct);
    }
}

