/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.query.parser;

import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.query.FromItem;
import org.eobjects.metamodel.query.FunctionType;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.parser.QueryParserException;
import org.eobjects.metamodel.query.parser.QueryPartProcessor;
import org.eobjects.metamodel.schema.Column;

public final class SelectItemParser
implements QueryPartProcessor {
    private final Query _query;
    private final boolean _allowExpressionBasedSelectItems;

    public SelectItemParser(Query query, boolean allowExpressionBasedSelectItems) {
        this._query = query;
        this._allowExpressionBasedSelectItems = allowExpressionBasedSelectItems;
    }

    @Override
    public void parse(String delim, String itemToken) throws MetaModelException {
        if ("*".equals(itemToken)) {
            this._query.selectAll();
            return;
        }
        String alias = null;
        int indexOfAlias = itemToken.toUpperCase().lastIndexOf(" AS ");
        if (indexOfAlias != -1) {
            alias = itemToken.substring(indexOfAlias + " AS ".length());
            itemToken = itemToken.substring(0, indexOfAlias);
        }
        try {
            SelectItem selectItem = this.findSelectItem(itemToken);
            if (selectItem == null) {
                throw new QueryParserException("Not capable of parsing SELECT token: " + itemToken);
            }
            if (alias != null) {
                selectItem.setAlias(alias);
            }
            this._query.select(selectItem);
        }
        catch (MultipleSelectItemsParsedException e) {
            FromItem fromItem = e.getFromItem();
            if (fromItem != null) {
                this._query.selectAll(fromItem);
            }
            throw e;
        }
    }

    public SelectItem findSelectItem(String expression) throws MultipleSelectItemsParsedException {
        FunctionType function;
        if ("*".equals(expression)) {
            throw new MultipleSelectItemsParsedException(null);
        }
        if ("COUNT(*)".equalsIgnoreCase(expression)) {
            return SelectItem.getCountAllItem();
        }
        int startParenthesis = expression.indexOf(40);
        if (startParenthesis > 0 && expression.endsWith(")")) {
            String functionName = expression.substring(0, startParenthesis);
            function = FunctionType.get(functionName);
            if (function != null) {
                expression = expression.substring(startParenthesis + 1, expression.length() - 1).trim();
                if (function == FunctionType.COUNT && "*".equals(expression)) {
                    return SelectItem.getCountAllItem();
                }
            }
        } else {
            function = null;
        }
        int lastIndexOfDot = expression.lastIndexOf(".");
        String columnName = null;
        FromItem fromItem = null;
        if (lastIndexOfDot != -1) {
            String prefix = expression.substring(0, lastIndexOfDot);
            columnName = expression.substring(lastIndexOfDot + 1);
            fromItem = this._query.getFromClause().getItemByReference(prefix);
        }
        if (fromItem == null) {
            if (this._query.getFromClause().getItemCount() == 1) {
                fromItem = (FromItem)this._query.getFromClause().getItem(0);
                columnName = expression;
            } else {
                fromItem = null;
                columnName = null;
            }
        }
        if (fromItem != null) {
            if ("*".equals(columnName)) {
                throw new MultipleSelectItemsParsedException(fromItem);
            }
            if (fromItem.getTable() != null) {
                Column column = fromItem.getTable().getColumnByName(columnName);
                if (column != null) {
                    SelectItem selectItem = new SelectItem(function, column, fromItem);
                    return selectItem;
                }
            } else if (fromItem.getSubQuery() != null) {
                Query subQuery = fromItem.getSubQuery();
                SelectItem subQuerySelectItem = new SelectItemParser(subQuery, this._allowExpressionBasedSelectItems).findSelectItem(columnName);
                if (subQuerySelectItem == null) {
                    return null;
                }
                return new SelectItem(subQuerySelectItem, fromItem);
            }
        }
        if (this._allowExpressionBasedSelectItems) {
            return new SelectItem(function, expression, null);
        }
        return null;
    }

    public static class MultipleSelectItemsParsedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final FromItem _fromItem;

        public MultipleSelectItemsParsedException(FromItem fromItem) {
            this._fromItem = fromItem;
        }

        public FromItem getFromItem() {
            return this._fromItem;
        }
    }
}

