/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.SuperColumnType;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.HasNameMapper;
import org.eobjects.metamodel.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTable
implements Table {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractTable.class);

    @Override
    public final int getColumnCount() {
        return this.getColumns().length;
    }

    @Override
    public Column getColumn(int index) throws IndexOutOfBoundsException {
        Column[] columns = this.getColumns();
        return columns[index];
    }

    @Override
    public final Column getColumnByName(String columnName) {
        if (columnName == null) {
            return null;
        }
        ArrayList<Column> foundColumns = new ArrayList<Column>(1);
        for (Column column : this.getColumns()) {
            String candidateName = column.getName();
            if (!columnName.equalsIgnoreCase(candidateName)) continue;
            foundColumns.add(column);
        }
        int numColumns = foundColumns.size();
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} column(s) matching '{}': {}", new Object[]{numColumns, columnName, foundColumns});
        }
        if (numColumns == 0) {
            return null;
        }
        if (numColumns == 1) {
            return (Column)foundColumns.get(0);
        }
        for (Column column : foundColumns) {
            if (!columnName.equals(column.getName())) continue;
            return column;
        }
        return (Column)foundColumns.get(0);
    }

    @Override
    public final int getRelationshipCount() {
        return this.getRelationships().length;
    }

    @Override
    public final Column[] getNumberColumns() {
        return CollectionUtils.filter(this.getColumns(), new Predicate<Column>(){

            @Override
            public Boolean eval(Column col) {
                ColumnType type = col.getType();
                return type != null && type.isNumber();
            }
        }).toArray(new Column[0]);
    }

    @Override
    public final Column[] getLiteralColumns() {
        return CollectionUtils.filter(this.getColumns(), new Predicate<Column>(){

            @Override
            public Boolean eval(Column col) {
                ColumnType type = col.getType();
                return type != null && type.isLiteral();
            }
        }).toArray(new Column[0]);
    }

    @Override
    public final Column[] getTimeBasedColumns() {
        return CollectionUtils.filter(this.getColumns(), new Predicate<Column>(){

            @Override
            public Boolean eval(Column col) {
                ColumnType type = col.getType();
                return type != null && type.isTimeBased();
            }
        }).toArray(new Column[0]);
    }

    @Override
    public final Column[] getBooleanColumns() {
        return CollectionUtils.filter(this.getColumns(), new Predicate<Column>(){

            @Override
            public Boolean eval(Column col) {
                ColumnType type = col.getType();
                return type != null && type.isBoolean();
            }
        }).toArray(new Column[0]);
    }

    @Override
    public final Column[] getIndexedColumns() {
        return CollectionUtils.filter(this.getColumns(), new Predicate<Column>(){

            @Override
            public Boolean eval(Column col) {
                return col.isIndexed();
            }
        }).toArray(new Column[0]);
    }

    @Override
    public final Relationship[] getForeignKeyRelationships() {
        return CollectionUtils.filter(this.getRelationships(), new Predicate<Relationship>(){

            @Override
            public Boolean eval(Relationship arg) {
                return AbstractTable.this.equals(arg.getForeignTable());
            }
        }).toArray(new Relationship[0]);
    }

    @Override
    public final Relationship[] getPrimaryKeyRelationships() {
        return CollectionUtils.filter(this.getRelationships(), new Predicate<Relationship>(){

            @Override
            public Boolean eval(Relationship arg) {
                return AbstractTable.this.equals(arg.getPrimaryTable());
            }
        }).toArray(new Relationship[0]);
    }

    @Override
    public final Column[] getForeignKeys() {
        final HashSet columns = new HashSet();
        Relationship[] relationships = this.getForeignKeyRelationships();
        CollectionUtils.forEach(relationships, new Action<Relationship>(){

            @Override
            public void run(Relationship arg) {
                Column[] foreignColumns;
                for (Column column : foreignColumns = arg.getForeignColumns()) {
                    columns.add(column);
                }
            }
        });
        return columns.toArray(new Column[columns.size()]);
    }

    @Override
    public final Column[] getPrimaryKeys() {
        Column[] columnsInTable;
        ArrayList<Column> primaryKeyColumns = new ArrayList<Column>();
        for (Column column : columnsInTable = this.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            primaryKeyColumns.add(column);
        }
        return primaryKeyColumns.toArray(new Column[primaryKeyColumns.size()]);
    }

    @Override
    public final String[] getColumnNames() {
        Column[] columns = this.getColumns();
        return CollectionUtils.map(columns, new HasNameMapper()).toArray(new String[columns.length]);
    }

    @Override
    public final Column[] getColumnsOfType(ColumnType columnType) {
        Column[] columns = this.getColumns();
        return MetaModelHelper.getColumnsByType(columns, columnType);
    }

    @Override
    public final Column[] getColumnsOfSuperType(SuperColumnType superColumnType) {
        Column[] columns = this.getColumns();
        return MetaModelHelper.getColumnsBySuperType(columns, superColumnType);
    }

    @Override
    public final Relationship[] getRelationships(final Table otherTable) {
        Relationship[] relationships = this.getRelationships();
        return CollectionUtils.filter(relationships, new Predicate<Relationship>(){

            @Override
            public Boolean eval(Relationship relation) {
                if (relation.getForeignTable() == otherTable && relation.getPrimaryTable() == AbstractTable.this) {
                    return true;
                }
                if (relation.getForeignTable() == AbstractTable.this && relation.getPrimaryTable() == otherTable) {
                    return true;
                }
                return false;
            }
        }).toArray(new Relationship[0]);
    }

    @Override
    public final String getQuotedName() {
        String quote = this.getQuote();
        if (quote == null) {
            return this.getName();
        }
        return quote + this.getName() + quote;
    }

    @Override
    public final String getQualifiedLabel() {
        StringBuilder sb = new StringBuilder();
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            sb.append(schema.getQualifiedLabel());
            sb.append('.');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public final String toString() {
        return "Table[name=" + this.getName() + ",type=" + (Object)((Object)this.getType()) + ",remarks=" + this.getRemarks() + "]";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table other = (Table)obj;
            if (!this.getQualifiedLabel().equals(other.getQualifiedLabel())) {
                return false;
            }
            if (this.getType() != other.getType()) {
                return false;
            }
            Schema sch1 = this.getSchema();
            Schema sch2 = other.getSchema();
            if (sch1 != null ? !sch1.equals(sch2) : sch2 != null) {
                return false;
            }
            try {
                Object[] columnNames1 = this.getColumnNames();
                Object[] columnNames2 = other.getColumnNames();
                if (columnNames1 != null && columnNames1.length != 0 && columnNames2 != null && columnNames2.length != 0 && !Arrays.equals(columnNames1, columnNames2)) {
                    return false;
                }
            }
            catch (Exception e) {
                logger.debug("Caught (and ignoring) exception while comparing column names of tables", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(Table that) {
        int diff = this.getQualifiedLabel().compareTo(that.getQualifiedLabel());
        if (diff == 0) {
            diff = this.toString().compareTo(that.toString());
        }
        return diff;
    }
}

