/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.io.Serializable;
import org.eobjects.metamodel.schema.AbstractRelationship;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ImmutableSchema;
import org.eobjects.metamodel.schema.ImmutableTable;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Table;

public final class ImmutableRelationship
extends AbstractRelationship
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Column[] primaryColumns;
    private final Column[] foreignColumns;

    public static void create(Relationship origRelationship, ImmutableSchema schema) {
        ImmutableTable primaryTable = ImmutableRelationship.getSimilarTable(origRelationship.getPrimaryTable(), schema);
        assert (primaryTable != null);
        Column[] primaryColumns = ImmutableRelationship.getSimilarColumns(origRelationship.getPrimaryColumns(), primaryTable);
        ImmutableRelationship.checkSameTable(primaryColumns);
        ImmutableTable foreignTable = ImmutableRelationship.getSimilarTable(origRelationship.getForeignTable(), schema);
        assert (foreignTable != null);
        Column[] foreignColumns = ImmutableRelationship.getSimilarColumns(origRelationship.getForeignColumns(), foreignTable);
        ImmutableRelationship.checkSameTable(foreignColumns);
        ImmutableRelationship relationship = new ImmutableRelationship(primaryColumns, foreignColumns);
        primaryTable.addRelationship(relationship);
        foreignTable.addRelationship(relationship);
    }

    private static Column[] getSimilarColumns(Column[] columns, Table table) {
        Column[] result = new Column[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String name = columns[i].getName();
            result[i] = table.getColumnByName(name);
        }
        return result;
    }

    private static ImmutableTable getSimilarTable(Table table, ImmutableSchema schema) {
        String name = table.getName();
        return (ImmutableTable)schema.getTableByName(name);
    }

    private ImmutableRelationship(Column[] primaryColumns, Column[] foreignColumns) {
        this.primaryColumns = primaryColumns;
        this.foreignColumns = foreignColumns;
    }

    @Override
    public Column[] getPrimaryColumns() {
        return this.primaryColumns;
    }

    @Override
    public Column[] getForeignColumns() {
        return this.foreignColumns;
    }
}

