/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.schema.AbstractSchema;
import org.eobjects.metamodel.schema.ImmutableRelationship;
import org.eobjects.metamodel.schema.ImmutableTable;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

public final class ImmutableSchema
extends AbstractSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ImmutableTable> tables = new ArrayList<ImmutableTable>();
    private String name;
    private String quote;

    private ImmutableSchema(String name, String quote) {
        this.name = name;
        this.quote = quote;
    }

    public ImmutableSchema(Schema schema) {
        this(schema.getName(), schema.getQuote());
        Relationship[] origRelationships;
        Table[] origTables;
        for (Table table : origTables = schema.getTables()) {
            this.tables.add(new ImmutableTable(table, this));
        }
        for (Relationship relationship : origRelationships = schema.getRelationships()) {
            ImmutableRelationship.create(relationship, this);
        }
    }

    @Override
    public Table[] getTables() {
        return this.tables.toArray(new Table[this.tables.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return this.quote;
    }
}

