/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.schema.AbstractTable;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ImmutableColumn;
import org.eobjects.metamodel.schema.ImmutableRelationship;
import org.eobjects.metamodel.schema.ImmutableSchema;
import org.eobjects.metamodel.schema.Relationship;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;

final class ImmutableTable
extends AbstractTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<ImmutableColumn> columns = new ArrayList<ImmutableColumn>();
    private final List<ImmutableRelationship> relationships = new ArrayList<ImmutableRelationship>();
    private final ImmutableSchema schema;
    private final TableType type;
    private final String remarks;
    private final String name;
    private final String quote;

    protected ImmutableTable(String name, TableType type, ImmutableSchema schema, String remarks, String quote) {
        this.name = name;
        this.type = type;
        this.schema = schema;
        this.remarks = remarks;
        this.quote = quote;
    }

    protected ImmutableTable(Table table, ImmutableSchema schema) {
        this(table.getName(), table.getType(), schema, table.getRemarks(), table.getQuote());
        Column[] origColumns;
        for (Column column : origColumns = table.getColumns()) {
            this.columns.add(new ImmutableColumn(column, this));
        }
    }

    protected void addRelationship(ImmutableRelationship relationship) {
        if (!this.relationships.contains(relationship)) {
            this.relationships.add(relationship);
        }
    }

    @Override
    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public TableType getType() {
        return this.type;
    }

    @Override
    public Relationship[] getRelationships() {
        return this.relationships.toArray(new Relationship[this.relationships.size()]);
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuote() {
        return this.quote;
    }
}

