/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.update;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.data.AbstractRowBuilder;
import org.eobjects.metamodel.data.Style;
import org.eobjects.metamodel.data.WhereClauseBuilder;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.query.builder.AbstractFilterBuilder;
import org.eobjects.metamodel.query.builder.FilterBuilder;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.RowUpdationBuilder;

public final class Update
extends AbstractRowBuilder<Update>
implements UpdateScript,
WhereClauseBuilder<Update> {
    private final Table _table;
    private final List<FilterItem> _whereItems;

    public Update(Table table) {
        super(table);
        this._table = table;
        this._whereItems = new ArrayList<FilterItem>();
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public void run(UpdateCallback callback) {
        RowUpdationBuilder updateBuilder = (RowUpdationBuilder)callback.update(this._table).where(this._whereItems);
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        Style[] styles = this.getStyles();
        boolean[] explicitNulls = this.getExplicitNulls();
        for (int i = 0; i < columns.length; ++i) {
            Object value = values[i];
            Column column = columns[i];
            Style style = styles[i];
            if (value == null) {
                if (!explicitNulls[i]) continue;
                updateBuilder = (RowUpdationBuilder)updateBuilder.value(column, value, style);
                continue;
            }
            updateBuilder = (RowUpdationBuilder)updateBuilder.value(column, value, style);
        }
        updateBuilder.execute();
    }

    @Override
    public FilterBuilder<Update> where(Column column) {
        SelectItem selectItem = new SelectItem(column);
        return new AbstractFilterBuilder<Update>(selectItem){

            @Override
            protected Update applyFilter(FilterItem filter) {
                return Update.this.where(filter);
            }
        };
    }

    @Override
    public FilterBuilder<Update> where(String columnName) {
        Column column = this._table.getColumnByName(columnName);
        if (column == null) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        return this.where(column);
    }

    @Override
    public Update where(FilterItem ... filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }

    @Override
    public Update where(Iterable<FilterItem> filterItems) {
        for (FilterItem filterItem : filterItems) {
            this._whereItems.add(filterItem);
        }
        return this;
    }
}

