/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BooleanComparator
implements Comparator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanComparator.class);
    private static BooleanComparator _instance = new BooleanComparator();

    private BooleanComparator() {
    }

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    public static Comparable<Object> getComparable(Object object) {
        final Boolean b = BooleanComparator.toBoolean(object);
        return new Comparable<Object>(){

            public boolean equals(Object obj) {
                return _instance.equals(obj);
            }

            @Override
            public int compareTo(Object o) {
                return _instance.compare(b, o);
            }

            public String toString() {
                return "BooleanComparable[boolean=" + b + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Boolean b1 = BooleanComparator.toBoolean(o1);
        Boolean b2 = BooleanComparator.toBoolean(o2);
        return b1.compareTo(b2);
    }

    public static Boolean toBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return BooleanComparator.parseBoolean((String)o);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Could not convert String '{}' to boolean, returning false", o);
                return false;
            }
        }
        if (o instanceof Number) {
            int i = ((Number)o).intValue();
            return i >= 1;
        }
        logger.warn("Could not convert '{}' to boolean, returning false", o);
        return false;
    }

    public static boolean parseBoolean(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        if ("true".equalsIgnoreCase(string = string.trim()) || "1".equals(string) || "y".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string) || "0".equals(string) || "n".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            return false;
        }
        throw new IllegalArgumentException("Could not get boolean value of string: " + string);
    }

    public static boolean isBoolean(Object o) {
        if (o instanceof Boolean) {
            return true;
        }
        return o instanceof String && ("true".equalsIgnoreCase((String)o) || "false".equalsIgnoreCase((String)o));
    }
}

