/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.ResourceException;
import org.eobjects.metamodel.util.UrlResource;

public class ClasspathResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _resourcePath;

    public ClasspathResource(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("Classpath resource path cannot be null");
        }
        this._resourcePath = resourcePath;
    }

    public String toString() {
        return "ClasspathResource[" + this._resourcePath + "]";
    }

    public String getResourcePath() {
        return this._resourcePath;
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._resourcePath;
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    protected ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    private UrlResource getUrlResourceDelegate() {
        ClassLoader classLoader = this.getClassLoader();
        URL url = classLoader.getResource(this._resourcePath);
        if (url == null && this._resourcePath.startsWith("/")) {
            url = classLoader.getResource(this._resourcePath.substring(1));
        }
        if (url == null) {
            return null;
        }
        return new UrlResource(url);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isExists() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return false;
        }
        return delegate.isExists();
    }

    @Override
    public long getSize() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return -1L;
        }
        return delegate.getSize();
    }

    @Override
    public long getLastModified() {
        UrlResource delegate = this.getUrlResourceDelegate();
        if (delegate == null) {
            return -1L;
        }
        return delegate.getLastModified();
    }

    @Override
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        this.getUrlResourceDelegate().write(writeCallback);
    }

    @Override
    public void append(Action<OutputStream> appendCallback) throws ResourceException {
        this.getUrlResourceDelegate().append(appendCallback);
    }

    @Override
    public InputStream read() throws ResourceException {
        return this.getUrlResourceDelegate().read();
    }

    @Override
    public void read(Action<InputStream> readCallback) throws ResourceException {
        this.getUrlResourceDelegate().read(readCallback);
    }

    @Override
    public <E> E read(Func<InputStream, E> readCallback) throws ResourceException {
        return this.getUrlResourceDelegate().read(readCallback);
    }
}

