/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Predicate;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <E> E[] array(E[] existingArray, E ... elements) {
        if (existingArray == null) {
            return elements;
        }
        Object result = Array.newInstance(existingArray.getClass().getComponentType(), existingArray.length + elements.length);
        System.arraycopy(existingArray, 0, result, 0, existingArray.length);
        System.arraycopy(elements, 0, result, existingArray.length, elements.length);
        return (Object[])result;
    }

    public static <E> List<E> concat(boolean removeDuplicates, Collection<? extends E> firstCollection, Collection<?> ... collections) {
        ArrayList<Object> result;
        if (removeDuplicates) {
            result = new ArrayList();
            CollectionUtils.addElements(removeDuplicates, result, firstCollection);
        } else {
            result = new ArrayList<E>(firstCollection);
        }
        Collection<?>[] arr$ = collections;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Collection<?> collection;
            Collection<?> elems = collection = arr$[i$];
            CollectionUtils.addElements(removeDuplicates, result, elems);
        }
        return result;
    }

    private static <E> void addElements(boolean removeDuplicates, List<E> result, Collection<? extends E> elements) {
        for (E item : elements) {
            if (removeDuplicates) {
                if (result.contains(item)) continue;
                result.add(item);
                continue;
            }
            result.add(item);
        }
    }

    public static <E> E[] arrayRemove(E[] array, E elementToRemove) {
        Object[] result = (Object[])CollectionUtils.arrayRemoveInternal(array, elementToRemove);
        return result;
    }

    public static Object arrayRemove(Object array, Object elementToRemove) {
        return CollectionUtils.arrayRemoveInternal(array, elementToRemove);
    }

    private static Object arrayRemoveInternal(Object array, Object elementToRemove) {
        boolean found = false;
        int oldLength = Array.getLength(array);
        if (oldLength == 0) {
            return array;
        }
        int newLength = oldLength - 1;
        Object result = Array.newInstance(array.getClass().getComponentType(), newLength);
        int nextIndex = 0;
        for (int i = 0; i < oldLength; ++i) {
            Object e = Array.get(array, i);
            if (e.equals(elementToRemove)) {
                found = true;
                continue;
            }
            if (nextIndex == newLength) break;
            Array.set(result, nextIndex, e);
            ++nextIndex;
        }
        if (!found) {
            return array;
        }
        return result;
    }

    public static <E> E[] arrayOf(Class<E> elementClass, Object arrayOrElement) {
        if (arrayOrElement == null) {
            return null;
        }
        if (arrayOrElement.getClass().isArray()) {
            return (Object[])arrayOrElement;
        }
        Object result = Array.newInstance(elementClass, 1);
        Array.set(result, 0, arrayOrElement);
        return (Object[])result;
    }

    public static <E> List<E> filter(E[] items, Predicate<? super E> predicate) {
        return CollectionUtils.filter(Arrays.asList(items), predicate);
    }

    public static <E> List<E> filter(Iterable<E> items, Predicate<? super E> predicate) {
        ArrayList<E> result = new ArrayList<E>();
        for (E e : items) {
            if (!((Boolean)predicate.eval(e)).booleanValue()) continue;
            result.add(e);
        }
        return result;
    }

    public static <I, O> List<O> map(I[] items, Func<? super I, O> func) {
        return CollectionUtils.map(Arrays.asList(items), func);
    }

    public static <I, O> List<O> map(Iterable<I> items, Func<? super I, O> func) {
        ArrayList<O> result = new ArrayList<O>();
        for (I item : items) {
            O output = func.eval(item);
            result.add(output);
        }
        return result;
    }

    public static <E> void forEach(E[] items, Action<? super E> action) {
        CollectionUtils.forEach(Arrays.asList(items), action);
    }

    public static <E> void forEach(Iterable<E> items, Action<? super E> action) {
        for (E item : items) {
            try {
                action.run(item);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException("Action threw exception", e);
            }
        }
    }

    public static <E> boolean isNullOrEmpty(E[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }

    public static List<?> toList(Object obj) {
        ArrayList<Object> result;
        if (obj == null) {
            result = Collections.emptyList();
        } else if (obj instanceof List) {
            ArrayList<Object> list;
            result = list = (ArrayList<Object>)obj;
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            result = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(obj, i));
            }
        } else if (obj instanceof Iterable) {
            result = new ArrayList<Object>();
            for (Object item : (Iterable)obj) {
                result.add(item);
            }
        } else if (obj instanceof Iterator) {
            result = new ArrayList();
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                result.add(it.next());
            }
        } else {
            result = new ArrayList(1);
            result.add(obj);
        }
        return result;
    }
}

