/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eobjects.metamodel.util.Month;
import org.eobjects.metamodel.util.Weekday;

public final class DateUtils {
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final long MILLISECONDS_PER_DAY = 86400000L;

    private DateUtils() {
    }

    public static Date get(int year, Month month, int dayOfMonth) {
        Calendar c = DateUtils.createCalendar();
        c.set(1, year);
        c.set(2, month.getCalendarConstant());
        c.set(5, dayOfMonth);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date get(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date get(Date originalDate, int daysDiff) {
        long millis = originalDate.getTime();
        long diff = (long)daysDiff * 86400000L;
        return new Date(millis += diff);
    }

    public static int getYear(Date date) {
        Calendar cal = DateUtils.createCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static Month getMonth(Date date) {
        Calendar cal = DateUtils.createCalendar();
        cal.setTime(date);
        int monthConstant = cal.get(2);
        return Month.getByCalendarConstant(monthConstant);
    }

    public static Weekday getWeekday(Date date) {
        Calendar cal = DateUtils.createCalendar();
        cal.setTime(date);
        int weekdayConstant = cal.get(7);
        return Weekday.getByCalendarConstant(weekdayConstant);
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = DateUtils.createCalendar();
        cal.setTime(date);
        return cal.get(5);
    }

    public static Calendar createCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        return c;
    }

    public static DateFormat createDateFormat() {
        return DateUtils.createDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat createDateFormat(String datePattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        return dateFormat;
    }
}

