/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.ResourceException;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File _file;

    public FileResource(String filename) {
        this._file = new File(filename);
    }

    public FileResource(File file) {
        this._file = file;
    }

    public String toString() {
        return "FileResource[" + this._file.getPath() + "]";
    }

    @Override
    public String getName() {
        return this._file.getName();
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isExists()) {
            return false;
        }
        boolean canWrite = this._file.canWrite();
        return !canWrite;
    }

    @Override
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        OutputStream out = FileHelper.getOutputStream(this._file);
        try {
            writeCallback.run(out);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in write callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
        }
        FileHelper.safeClose(out);
    }

    @Override
    public void append(Action<OutputStream> appendCallback) {
        OutputStream out = FileHelper.getOutputStream(this._file, true);
        try {
            appendCallback.run(out);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in append callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(out);
                throw throwable;
            }
        }
        FileHelper.safeClose(out);
    }

    @Override
    public void read(Action<InputStream> readCallback) {
        InputStream in = this.read();
        try {
            readCallback.run(in);
        }
        catch (Exception e) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
    }

    @Override
    public <E> E read(Func<InputStream, E> readCallback) {
        E e;
        InputStream in = this.read();
        try {
            E result;
            e = result = readCallback.eval(in);
        }
        catch (Exception e2) {
            try {
                throw new ResourceException(this, "Error occurred in read callback", e2);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose(in);
                throw throwable;
            }
        }
        FileHelper.safeClose(in);
        return e;
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public boolean isExists() {
        return this._file.exists();
    }

    @Override
    public long getSize() {
        return this._file.length();
    }

    @Override
    public long getLastModified() {
        long lastModified = this._file.lastModified();
        if (lastModified == 0L) {
            return -1L;
        }
        return lastModified;
    }

    @Override
    public InputStream read() throws ResourceException {
        InputStream in = FileHelper.getInputStream(this._file);
        return in;
    }
}

