/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Resource;
import org.eobjects.metamodel.util.ResourceException;

public class InMemoryResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _path;
    private byte[] _contents;
    private long _lastModified;

    public InMemoryResource(String path) {
        this(path, new byte[0], -1L);
    }

    public InMemoryResource(String path, byte[] contents, long lastModified) {
        this._path = path;
        this._contents = contents;
        this._lastModified = lastModified;
    }

    public String toString() {
        return "InMemoryResource[" + this._path + "]";
    }

    @Override
    public String getName() {
        String lastPart;
        int lastBackSlash;
        String name = this._path;
        int lastSlash = name.lastIndexOf(47);
        int lastIndex = Math.max(lastSlash, lastBackSlash = name.lastIndexOf(92));
        if (lastIndex != -1 && !"".equals(lastPart = name.substring(lastIndex + 1))) {
            return lastPart;
        }
        return name;
    }

    public String getPath() {
        return this._path;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isExists() {
        return true;
    }

    @Override
    public long getSize() {
        return this._contents.length;
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public void write(Action<OutputStream> writeCallback) throws ResourceException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writeCallback.run(baos);
            this._contents = baos.toByteArray();
            this._lastModified = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    @Override
    public void append(Action<OutputStream> appendCallback) throws ResourceException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this._contents);
            appendCallback.run(baos);
            this._contents = baos.toByteArray();
            this._lastModified = System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    @Override
    public InputStream read() throws ResourceException {
        return new ByteArrayInputStream(this._contents);
    }

    @Override
    public void read(Action<InputStream> readCallback) throws ResourceException {
        InputStream inputStream = this.read();
        try {
            readCallback.run(inputStream);
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }

    @Override
    public <E> E read(Func<InputStream, E> readCallback) throws ResourceException {
        InputStream inputStream = this.read();
        try {
            return readCallback.eval(inputStream);
        }
        catch (Exception e) {
            throw new ResourceException((Resource)this, e);
        }
    }
}

