/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberComparator
implements Comparator<Object> {
    private static final Logger logger = LoggerFactory.getLogger(NumberComparator.class);
    private static final Comparator<Object> _instance = new NumberComparator();

    public static Comparator<Object> getComparator() {
        return _instance;
    }

    private NumberComparator() {
    }

    public static Comparable<Object> getComparable(Object o) {
        final Number n = NumberComparator.toNumber(o);
        return new Comparable<Object>(){

            public boolean equals(Object obj) {
                return ((Object)_instance).equals(obj);
            }

            @Override
            public int compareTo(Object o) {
                return _instance.compare(n, o);
            }

            public String toString() {
                return "NumberComparable[number=" + n + "]";
            }
        };
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        Number n1 = NumberComparator.toNumber(o1);
        Number n2 = NumberComparator.toNumber(o2);
        return Double.valueOf(n1.doubleValue()).compareTo(n2.doubleValue());
    }

    public static Number toNumber(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Boolean) {
            if (Boolean.TRUE.equals(value)) {
                return 1;
            }
            return 0;
        }
        String stringValue = value.toString();
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e2) {
                logger.warn("Could not convert '{}' to number, returning null", value);
                return null;
            }
        }
    }
}

