/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UnicodeWriter
extends Writer {
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    private final OutputStreamWriter writer;

    public UnicodeWriter(String fileName, String encoding) throws UnsupportedEncodingException, IOException {
        this(new FileOutputStream(fileName), encoding);
    }

    public UnicodeWriter(File file, String encoding) throws UnsupportedEncodingException, IOException {
        this(new FileOutputStream(file), encoding);
    }

    public UnicodeWriter(OutputStream outputStream, String encoding) throws UnsupportedEncodingException, IOException {
        this.writer = this.createWriter(outputStream, encoding);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    private OutputStreamWriter createWriter(OutputStream outputStream, String encoding) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
        if ("UTF8".equalsIgnoreCase(encoding = encoding.replaceAll("-", ""))) {
            outputStream.write(UTF8_BOM, 0, UTF8_BOM.length);
        } else if ("UTF16LE".equalsIgnoreCase(encoding)) {
            outputStream.write(UTF16LE_BOM, 0, UTF16LE_BOM.length);
        } else if ("UTF16BE".equalsIgnoreCase(encoding)) {
            outputStream.write(UTF16BE_BOM, 0, UTF16BE_BOM.length);
        } else if ("UTF32LE".equalsIgnoreCase(encoding)) {
            outputStream.write(UTF32LE_BOM, 0, UTF32LE_BOM.length);
        } else if ("UTF32".equalsIgnoreCase(encoding) || "UTF32BE".equalsIgnoreCase(encoding)) {
            outputStream.write(UTF32BE_BOM, 0, UTF32BE_BOM.length);
        }
        return writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }
}

