/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.couchdb;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.StreamingViewResult;
import org.ektorp.ViewResult;
import org.eobjects.metamodel.data.AbstractDataSet;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.query.SelectItem;

final class CouchDbDataSet
extends AbstractDataSet {
    private final Iterator<ViewResult.Row> _iterator;
    private final StreamingViewResult _streamingViewResult;
    private DefaultRow _row;

    public CouchDbDataSet(SelectItem[] selectItems, StreamingViewResult streamingViewResult) {
        super(selectItems);
        this._streamingViewResult = streamingViewResult;
        this._iterator = this._streamingViewResult.iterator();
    }

    public boolean next() {
        if (this._iterator == null || !this._iterator.hasNext()) {
            return false;
        }
        ViewResult.Row row = this._iterator.next();
        JsonNode node = row.getDocAsNode();
        int size = this.getHeader().size();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            String key = this.getHeader().getSelectItem(i).getColumn().getName();
            JsonNode valueNode = node.get(key);
            Object value = valueNode == null || valueNode.isNull() ? null : (valueNode.isTextual() ? valueNode.asText() : (valueNode.isArray() ? this.toList(valueNode) : (valueNode.isObject() ? this.toMap(valueNode) : (valueNode.isBoolean() ? (Serializable)Boolean.valueOf(valueNode.asBoolean()) : (Serializable)(valueNode.isInt() ? (Number)valueNode.asInt() : (Number)(valueNode.isLong() ? (Number)valueNode.asLong() : (Number)(valueNode.isDouble() ? Double.valueOf(valueNode.asDouble()) : valueNode)))))));
            values[i] = value;
        }
        this._row = new DefaultRow(this.getHeader(), values);
        return true;
    }

    private Map<String, Object> toMap(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            return (Map)new ObjectMapper().reader(Map.class).readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Object toList(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            return new ObjectMapper().reader(List.class).readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Row getRow() {
        return this._row;
    }

    public void close() {
        super.close();
        this._streamingViewResult.close();
    }
}

