/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.couchdb;

import java.util.HashMap;
import org.ektorp.CouchDbConnector;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.couchdb.CouchDbDataContext;
import org.eobjects.metamodel.couchdb.CouchDbUpdateCallback;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.update.AbstractRowUpdationBuilder;

final class CouchDbRowUpdationBuilder
extends AbstractRowUpdationBuilder {
    private final CouchDbUpdateCallback _updateCallback;

    public CouchDbRowUpdationBuilder(CouchDbUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MetaModelException {
        Table table = this.getTable();
        CouchDbConnector connector = this._updateCallback.getConnector(table.getName());
        HashMap<String, Object> prototype = new HashMap<String, Object>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!this.isSet(column)) continue;
            String columnName = column.getName();
            Object value = values[i];
            prototype.put(columnName, value);
        }
        CouchDbDataContext dc = this._updateCallback.getDataContext();
        DataSet dataSet = dc.query().from(table).select(table.getColumns()).where((Iterable)this.getWhereItems()).execute();
        try {
            while (dataSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(prototype);
                Row row = dataSet.getRow();
                for (Column column : table.getColumns()) {
                    if (map.containsKey(column.getName())) continue;
                    map.put(column.getName(), row.getValue(column));
                }
                connector.update(map);
            }
        }
        finally {
            dataSet.close();
        }
    }
}

