/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvDataSet;
import org.eobjects.metamodel.csv.CsvSchema;
import org.eobjects.metamodel.csv.CsvTable;
import org.eobjects.metamodel.csv.CsvUpdateCallback;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.query.FilterItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(CsvDataContext.class);
    private final Object WRITE_LOCK = new Object();
    private final File _file;
    private final CsvConfiguration _configuration;
    private final boolean _writable;

    public CsvDataContext(File file, CsvConfiguration configuration) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("CsvConfiguration cannot be null");
        }
        this._file = file;
        this._configuration = configuration;
        this._writable = true;
    }

    public CsvDataContext(URL url, CsvConfiguration configuration) {
        this._file = CsvDataContext.createFileFromInputStream(url, configuration.getEncoding());
        this._configuration = configuration;
        this._writable = false;
    }

    public CsvDataContext(File file) {
        this(file, new CsvConfiguration());
    }

    public CsvDataContext(InputStream inputStream, CsvConfiguration configuration) {
        this._file = CsvDataContext.createFileFromInputStream(inputStream, configuration.getEncoding());
        this._configuration = configuration;
        this._writable = false;
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar) {
        this(file, separatorChar, '\"');
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar, char quoteChar) {
        this(file, new CsvConfiguration(1, "UTF-8", separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar, char quoteChar, String encoding) {
        this(file, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(URL url, char separatorChar, char quoteChar) {
        this(url, separatorChar, quoteChar, "UTF-8");
    }

    @Deprecated
    public CsvDataContext(URL url, char separatorChar, char quoteChar, String encoding) {
        this(url, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(InputStream inputStream, char separatorChar, char quoteChar) {
        this(inputStream, new CsvConfiguration(1, "UTF-8", separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(InputStream inputStream, char separatorChar, char quoteChar, String encoding) {
        this(inputStream, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    public CsvConfiguration getConfiguration() {
        return this._configuration;
    }

    public File getFile() {
        return this._file;
    }

    private static File createFileFromInputStream(URL url, String encoding) {
        try {
            return CsvDataContext.createFileFromInputStream(url.openStream(), encoding);
        }
        catch (IOException e) {
            logger.error("Could not open URL input stream", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static File createFileFromInputStream(InputStream inputStream, String encoding) {
        File tempDir = FileHelper.getTempDir();
        File fileCandidate = null;
        boolean usableName = false;
        int index = 0;
        while (!usableName) {
            fileCandidate = new File(tempDir, "metamodel" + ++index + ".csv");
            usableName = !fileCandidate.exists();
        }
        File file = fileCandidate;
        BufferedWriter writer = FileHelper.getBufferedWriter(file, (String)encoding);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            file.createNewFile();
            file.deleteOnExit();
            boolean firstLine = true;
            String line = reader.readLine();
            while (line != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.write(10);
                }
                writer.write(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{writer, reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{writer, reader});
        return file;
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        Long l;
        if (!functionApproximationAllowed) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            int read;
            long length = this._file.length();
            int sampleSize = (int)Math.min(length, 0x500000L);
            int chunkSize = Math.min(sampleSize, 0x100000);
            int readSize = 0;
            int newlines = 0;
            int carriageReturns = 0;
            byte[] byteBuffer = new byte[chunkSize];
            char[] charBuffer = new char[chunkSize];
            inputStream = new FileInputStream(this._file);
            while (readSize < sampleSize && (read = ((InputStream)inputStream).read(byteBuffer)) != -1) {
                readSize += read;
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byteBuffer), this._configuration.getEncoding());
                reader.read(charBuffer);
                for (char c : charBuffer) {
                    if ('\n' == c) {
                        ++newlines;
                        continue;
                    }
                    if ('\r' != c) continue;
                    ++carriageReturns;
                }
            }
            int lines = Math.max(newlines, carriageReturns);
            logger.info("Found {} lines breaks in {} bytes", (Object)lines, (Object)sampleSize);
            long approxCount = (long)lines * length / (long)sampleSize;
            l = approxCount;
        }
        catch (IOException e) {
            try {
                logger.error("Unexpected error during COUNT(*) approximation", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return l;
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        int lineNumber = this._configuration.getColumnNameLineNumber();
        CSVReader reader = this.createCsvReader(lineNumber);
        int columnCount = table.getColumnCount();
        if (maxRows < 0) {
            return new CsvDataSet(reader, columns, null, columnCount, this._configuration.isFailOnInconsistentRowLength());
        }
        return new CsvDataSet(reader, columns, maxRows, columnCount, this._configuration.isFailOnInconsistentRowLength());
    }

    protected CSVReader createCsvReader(int skipLines) {
        Reader fileReader = FileHelper.getReader((File)this._file, (String)this._configuration.getEncoding());
        CSVReader csvReader = new CSVReader(fileReader, this._configuration.getSeparatorChar(), this._configuration.getQuoteChar(), this._configuration.getEscapeChar(), skipLines);
        return csvReader;
    }

    protected CsvSchema getMainSchema() throws MetaModelException {
        CsvSchema schema = new CsvSchema(this.getMainSchemaName(), this);
        if (this._file.exists()) {
            schema.setTable(new CsvTable(schema));
        }
        return schema;
    }

    protected String getMainSchemaName() {
        return this._file.getName();
    }

    protected boolean isWritable() {
        return this._writable;
    }

    private void checkWritable() {
        if (!this.isWritable()) {
            throw new IllegalStateException("This CSV DataContext is not writable, as it based on a read-only resource.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update) {
        this.checkWritable();
        CsvUpdateCallback callback = new CsvUpdateCallback(this);
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            try {
                update.run((UpdateCallback)callback);
            }
            finally {
                callback.close();
            }
        }
    }
}

