/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.csv;

import java.io.File;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.csv.CsvUpdateCallback;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.Row;
import org.eobjects.metamodel.delete.AbstractRowDeletionBuilder;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CsvDeleteBuilder
extends AbstractRowDeletionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CsvDeleteBuilder.class);
    private final CsvUpdateCallback _updateCallback;

    public CsvDeleteBuilder(CsvUpdateCallback updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
    }

    public void execute() throws MetaModelException {
        File originalFile = this._updateCallback.getFile();
        String directory = originalFile.getParent();
        File copyFile = new File(directory, originalFile.getName() + ".metamodel.temp.csv");
        if (copyFile.exists()) {
            throw new MetaModelException("Temp file (" + copyFile + ") already exists. This is most probably due to multiple CSV DataContexts referring the same file and multiple operations are being applied.");
        }
        CsvConfiguration configuration = this._updateCallback.getConfiguration();
        final CsvDataContext copyDataContext = new CsvDataContext(copyFile, configuration);
        copyDataContext.executeUpdate(new UpdateScript(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(UpdateCallback callback) {
                Table originalTable = CsvDeleteBuilder.this.getTable();
                Table copyTable = callback.createTable(copyDataContext.getDefaultSchema(), originalTable.getName()).like(originalTable).execute();
                DataSet dataSet = CsvDeleteBuilder.this._updateCallback.getDataContext().query().from(originalTable).select(originalTable.getColumns()).execute();
                try {
                    while (dataSet.next()) {
                        Row row = dataSet.getRow();
                        if (CsvDeleteBuilder.this.deleteRow(row)) continue;
                        callback.insertInto(copyTable).like(row).execute();
                    }
                }
                finally {
                    dataSet.close();
                }
            }
        });
        FileHelper.copy((File)copyFile, (File)originalFile);
        boolean deleted = copyFile.delete();
        if (!deleted) {
            logger.warn("Could not delete temporary copy-file: {}", (Object)copyFile);
        }
    }
}

