/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.dbase;

import java.io.Closeable;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.eobjects.metamodel.MetaModelException;
import org.eobjects.metamodel.MetaModelHelper;
import org.eobjects.metamodel.QueryPostprocessDataContext;
import org.eobjects.metamodel.data.CachingDataSetHeader;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.DataSetHeader;
import org.eobjects.metamodel.data.DefaultRow;
import org.eobjects.metamodel.data.InMemoryDataSet;
import org.eobjects.metamodel.query.SelectItem;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.schema.TableType;
import org.eobjects.metamodel.util.FileHelper;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.DateField;
import org.xBaseJ.fields.Field;
import org.xBaseJ.fields.FloatField;
import org.xBaseJ.fields.LogicalField;
import org.xBaseJ.fields.MemoField;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.fields.PictureField;

public final class DbaseDataContext
extends QueryPostprocessDataContext
implements Closeable {
    private final String filename;
    private DBF dbf;

    public DbaseDataContext(String filename) {
        this.filename = filename;
    }

    public DbaseDataContext(File file) {
        this.filename = file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBF getDbf() {
        if (this.dbf == null) {
            DbaseDataContext dbaseDataContext = this;
            synchronized (dbaseDataContext) {
                if (this.dbf == null) {
                    try {
                        this.dbf = new DBF(this.filename);
                    }
                    catch (Exception e) {
                        throw new MetaModelException("Could not open DBF file");
                    }
                }
            }
        }
        return this.dbf;
    }

    protected Schema getMainSchema() throws MetaModelException {
        DBF dbf = this.getDbf();
        String schemaName = dbf.getName();
        int separatorIndex = Math.max(schemaName.lastIndexOf(47), schemaName.lastIndexOf(92));
        if (separatorIndex != -1) {
            schemaName = schemaName.substring(separatorIndex + 1);
        }
        MutableSchema schema = new MutableSchema(schemaName);
        MutableTable table = new MutableTable(schemaName.substring(0, schemaName.length() - 4), TableType.TABLE, (Schema)schema);
        schema.addTable(table);
        for (int i = 0; i < dbf.getFieldCount(); ++i) {
            try {
                Field field = dbf.getField(i + 1);
                MutableColumn column = new MutableColumn(field.getName());
                ColumnType columnType = ColumnType.VARCHAR;
                if (field instanceof FloatField) {
                    columnType = ColumnType.FLOAT;
                } else if (field instanceof NumField) {
                    columnType = ColumnType.DOUBLE;
                } else if (field instanceof CharField) {
                    columnType = ColumnType.CHAR;
                } else if (field instanceof DateField) {
                    columnType = ColumnType.DATE;
                } else if (field instanceof MemoField) {
                    columnType = ColumnType.VARCHAR;
                } else if (field instanceof LogicalField) {
                    columnType = ColumnType.OTHER;
                } else if (field instanceof PictureField) {
                    columnType = ColumnType.OTHER;
                }
                column.setType(columnType);
                column.setTable((Table)table);
                column.setColumnNumber(i);
                column.setNativeType("" + field.getType());
                column.setColumnSize(Integer.valueOf(field.getLength()));
                table.addColumn((Column)column);
                continue;
            }
            catch (Exception e) {
                throw new MetaModelException("Could not retrieve DBF field", e);
            }
        }
        return schema;
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.getMainSchema().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        DBF dbf;
        DBF dBF = dbf = this.getDbf();
        synchronized (dBF) {
            int rowNum = 0;
            try {
                dbf.gotoRecord(1);
            }
            catch (Exception e) {
                throw new MetaModelException(e);
            }
            SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])columns);
            CachingDataSetHeader header = new CachingDataSetHeader(selectItems);
            LinkedList<DefaultRow> rowValues = new LinkedList<DefaultRow>();
            while (maxRows < 0 || rowNum < maxRows) {
                ++rowNum;
                try {
                    Object[] values = new Object[columns.length];
                    for (int i = 0; i < columns.length; ++i) {
                        int fieldNumber = 1 + columns[i].getColumnNumber();
                        Field field = dbf.getField(fieldNumber);
                        values[i] = this.convert(field.get(), columns[i].getType());
                    }
                    rowValues.add(new DefaultRow((DataSetHeader)header, values));
                }
                catch (Exception e) {
                    throw new MetaModelException(e);
                }
                try {
                    dbf.read();
                }
                catch (Exception e) {
                    if ("End Of File".equals(e.getMessage())) break;
                    throw new MetaModelException(e);
                }
            }
            return new InMemoryDataSet((DataSetHeader)header, rowValues);
        }
    }

    private Object convert(String stringValue, ColumnType type) {
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        switch (type) {
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(stringValue));
            }
            case DOUBLE: {
                return Double.parseDouble(stringValue);
            }
            case DATE: {
                try {
                    Date date = new SimpleDateFormat("yyyyMMdd").parse(stringValue);
                    return date;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(stringValue);
                }
            }
        }
        return stringValue;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this.dbf});
    }
}

