/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.metamodel.excel;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eobjects.metamodel.data.DataSet;
import org.eobjects.metamodel.data.EmptyDataSet;
import org.eobjects.metamodel.data.MaxRowsDataSet;
import org.eobjects.metamodel.excel.ExcelConfiguration;
import org.eobjects.metamodel.excel.ExcelUtils;
import org.eobjects.metamodel.excel.SpreadsheetReaderDelegate;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.AlphabeticSequence;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSpreadsheetReaderDelegate
implements SpreadsheetReaderDelegate {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpreadsheetReaderDelegate.class);
    private final ExcelConfiguration _configuration;

    public DefaultSpreadsheetReaderDelegate(ExcelConfiguration configuration) {
        this._configuration = configuration;
    }

    @Override
    public Schema createSchema(InputStream inputStream, String schemaName) {
        MutableSchema schema = new MutableSchema(schemaName);
        Workbook wb = ExcelUtils.readWorkbook(inputStream);
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            Sheet currentSheet = wb.getSheetAt(i);
            MutableTable table = this.createTable(wb, currentSheet);
            table.setSchema((Schema)schema);
            schema.addTable(table);
        }
        return schema;
    }

    @Override
    public DataSet executeQuery(InputStream inputStream, Table table, Column[] columns, int maxRows) {
        Workbook wb = ExcelUtils.readWorkbook(inputStream);
        Sheet sheet = wb.getSheet(table.getName());
        if (sheet == null || sheet.getPhysicalNumberOfRows() == 0) {
            return new EmptyDataSet(columns);
        }
        DataSet dataSet = ExcelUtils.getDataSet(wb, sheet, table, this._configuration);
        if (maxRows > 0) {
            dataSet = new MaxRowsDataSet(dataSet, maxRows);
        }
        return dataSet;
    }

    @Override
    public void notifyTablesModified(Ref<InputStream> inputStreamRef) {
    }

    private MutableTable createTable(Workbook wb, Sheet sheet) {
        int columnNameLineNumber;
        MutableTable table = new MutableTable(sheet.getSheetName());
        if (sheet.getPhysicalNumberOfRows() <= 0) {
            return table;
        }
        Iterator<Row> rowIterator = ExcelUtils.getRowIterator(sheet, this._configuration, false);
        if (!rowIterator.hasNext()) {
            return table;
        }
        Row row = null;
        if (this._configuration.isSkipEmptyLines()) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
        } else {
            row = rowIterator.next();
        }
        if ((columnNameLineNumber = this._configuration.getColumnNameLineNumber()) == 0) {
            while (row == null && rowIterator.hasNext()) {
                row = rowIterator.next();
            }
            AlphabeticSequence sequence = new AlphabeticSequence();
            int offset = this.getColumnOffset(row);
            for (int i = 0; i < offset; ++i) {
                sequence.next();
            }
            for (int j = offset; j < row.getLastCellNum(); ++j) {
                MutableColumn column = new MutableColumn(sequence.next(), ColumnType.VARCHAR, (Table)table, j, Boolean.valueOf(true));
                table.addColumn((Column)column);
            }
        } else {
            boolean hasColumns = true;
            for (int j = 1; j < columnNameLineNumber; ++j) {
                if (!rowIterator.hasNext()) {
                    hasColumns = false;
                    break;
                }
                row = rowIterator.next();
            }
            if (hasColumns) {
                this.createColumns(table, wb, row);
            }
        }
        return table;
    }

    private void createColumns(MutableTable table, Workbook wb, Row row) {
        int offset;
        if (row == null) {
            logger.warn("Cannot create columns based on null row!");
            return;
        }
        short rowLength = row.getLastCellNum();
        for (int j = offset = this.getColumnOffset(row); j < rowLength; ++j) {
            Cell cell = row.getCell(j);
            String columnName = ExcelUtils.getCellValue(wb, cell);
            if (columnName == null || "".equals(columnName)) {
                columnName = "[Column " + (j + 1) + "]";
            }
            MutableColumn column = new MutableColumn(columnName, ColumnType.VARCHAR, (Table)table, j, Boolean.valueOf(true));
            table.addColumn((Column)column);
        }
    }

    private int getColumnOffset(Row row) {
        short offset = this._configuration.isSkipEmptyColumns() ? row.getFirstCellNum() : (short)0;
        return offset;
    }
}

